//******************************************************************************
//
// MIDITrail / MTNoteRain
//
// m[gC`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

// MEMO:
// m[gC`悷B

#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include "SMIDILib.h"
#include "DXPrimitive.h"
#include "MTNoteDesign.h"
#include "MTNotePitchBend.h"
#include "MTPianoKeyboardDesign.h"

using namespace SMIDILib;


//******************************************************************************
// p[^`
//******************************************************************************
//ő唭m[g`搔
#define MTNOTERAIN_MAX_ACTIVENOTE_NUM  (100)

// TODO: ő唭m[g`搔ςɂ
//   OɃV[PXf[^̍ő哯𒲍Ă
//   mۂobt@TCYύXł
//   łobt@TCY͏_œIɕύX\ł


//******************************************************************************
// m[gC`NX
//******************************************************************************
class MTNoteRain
{
public:

	//RXgN^^fXgN^
	MTNoteRain(void);
	virtual ~MTNoteRain(void);

	//
	int Create(
			LPDIRECT3DDEVICE9 pD3DDevice,
			const TCHAR* pSceneName,
			SMSeqData* pSeqData,
			MTNotePitchBend* pNotePitchBend
		);

	//XV
	int Transform(LPDIRECT3DDEVICE9 pD3DDevice, float rollAngle);

	//`
	int Draw(LPDIRECT3DDEVICE9 pD3DDevice);

	//
	void Release();

	//t`bN^Co^
	void SetCurTickTime(unsigned long curTickTime);

	//Zbg
	void Reset();

	//݈ʒu擾
	float GetPos();

private:

	//m[g\
	struct NoteStatus {
		bool isActive;
		unsigned long index;
		unsigned long startTime;
	};

	//_obt@\
	struct MTNOTERAIN_VERTEX {
		D3DXVECTOR3 p;	//_W
		D3DXVECTOR3 n;	//@
		DWORD       c;	//fBt[YF
	};

private:

	//m[gfUC
	MTNoteDesign m_NoteDesign;

	//L[{[hfUC
	MTPianoKeyboardDesign m_KeyboardDesign;

	//m[gXg
	SMNoteList m_NoteList;

	//Sm[gC
	DXPrimitive m_PrimitiveAllNotes;

	//m[g{bNX
	unsigned long m_CurTickTime;
	unsigned long m_CurNoteIndex;
	NoteStatus* m_pNoteStatus;
	float m_CurPos;

	//sb`xh
	MTNotePitchBend* m_pNotePitchBend;

	//_obt@FVFtH[}bg
	DWORD _GetFVFFormat(){ return (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE); }

	int _CreateAllNoteRain(LPDIRECT3DDEVICE9 pD3DDevice);
	int _CreateVertexOfNote(
				SMNote note,
				MTNOTERAIN_VERTEX* pVertex,
				unsigned long vertexOffset,
				unsigned long* pIndex
			);
	int _CreateNoteStatus();
	void _MakeMaterial(D3DMATERIAL9* pMaterial);
	int _TransformActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateStatusOfActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateActiveNotes(LPDIRECT3DDEVICE9 pD3DDevice);
	int _UpdateVertexOfNote(
				unsigned long index,
				bool isEnablePitchBendShift = false
			);

};


