//******************************************************************************
//
// MIDITrail / MTSceneTitle
//
// ^CgV[`NX
//
// Copyright (C) 2010 WADA Masashi. All Rights Reserved.
//
//******************************************************************************


#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTSceneTitle.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTSceneTitle::MTSceneTitle(void)
{
	m_CamPosZ = MTSCENETITLE_CAMERA_POSZ;
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTSceneTitle::~MTSceneTitle(void)
{
}

//******************************************************************************
// ̎擾
//******************************************************************************
const TCHAR* MTSceneTitle::GetName()
{
	return _T("Title");
}

//******************************************************************************
// V[
//******************************************************************************
int MTSceneTitle::Create(
		HWND hWnd,
		LPDIRECT3DDEVICE9 pD3DDevice,
		SMSeqData* pSeqData
	)
{
	int result = 0;

	Release();

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//----------------------------------
	// J
	//----------------------------------
	//J
	result = m_Camera.Initialize();
	if (result != 0) goto EXIT;

	//{p[^ݒ
	m_Camera.SetBaseParam(
			45.0f,		//p
			1.0f,		//Nearv[
			1000.0f		//Farv[
		);

	//Jʒuݒ
	m_Camera.SetPosition(
			D3DXVECTOR3(0.0f, 0.0f, m_CamPosZ),	//Jʒu
			D3DXVECTOR3(0.0f, 0.0f, 0.0f), 		//ړ_
			D3DXVECTOR3(0.0f, 1.0f, 0.0f)		//J
		);
	
	//----------------------------------
	// Cg
	//----------------------------------
	//Cg
	result = m_DirLight.Initialize();
	if (result != 0) goto EXIT;

	//Cg
	m_DirLight.SetDirection(D3DXVECTOR3(1.0f, -1.0f, 2.0f));

	//Cg̃foCXo^
//	result = m_DirLight.SetDevice(pD3DDevice, TRUE);  //Cg
	result = m_DirLight.SetDevice(pD3DDevice, FALSE); //CgȂ
	if (result != 0) goto EXIT;

	//----------------------------------
	// `IuWFNg
	//----------------------------------
	//S
	result = m_Logo.Create(pD3DDevice);
	if (result != 0) goto EXIT;

	//----------------------------------
	// _OXe[g
	//----------------------------------
	//ʕ`惂[h
	pD3DDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);

	//Z[xrFON
	 pD3DDevice->SetRenderState(D3DRS_ZENABLE, TRUE);

	//fBUO:ON i`
	pD3DDevice->SetRenderState(D3DRS_DITHERENABLE, TRUE);

	//}`TvOA`GCAXFL
	pD3DDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, TRUE);

	//_OXe[gݒFʏ̃At@
	pD3DDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
	pD3DDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	pD3DDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

EXIT:;
	return result;
}

//******************************************************************************
// ϊ
//******************************************************************************
int MTSceneTitle::Transform(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//Jʒuݒ
	m_CamPosZ += MTSCENETITLE_CAMERA_POSZ_DELTA;
	m_Camera.SetPosition(
			D3DXVECTOR3(0.0f, 0.0f, m_CamPosZ),	//Jʒu
			D3DXVECTOR3(0.0f, 0.0f, 0.0f), 		//ړ_
			D3DXVECTOR3(0.0f, 1.0f, 0.0f)		//J
		);

	//JXV
	result = m_Camera.Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//SXV
	result = m_Logo.Transform(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// `
//******************************************************************************
int MTSceneTitle::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//XV
	result = Transform(pD3DDevice);
	if (result != 0) goto EXIT;

	//S`
	result = m_Logo.Draw(pD3DDevice);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// j
//******************************************************************************
void MTSceneTitle::Release()
{
	m_Logo.Release();
}

