//******************************************************************************
//
// Simple MIDI Library / SMNoteList
//
// ノートリストクラス
//
// Copyright (C) 2010-2017 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#import "SMSimpleList.h"


//******************************************************************************
// ノート情報構造体
//******************************************************************************
//ノート情報
typedef struct {
	unsigned char portNo;
	unsigned char chNo;
	unsigned char noteNo;
	unsigned char velocity;
	unsigned int startTime;
	unsigned int endTime;
} SMNote;

//******************************************************************************
// ノートリストクラス
//******************************************************************************
class SMNoteList
{
public:
	
	//コンストラクタ／デストラクタ
	SMNoteList(void);
	virtual ~SMNoteList(void);
	
	//クリア
	void Clear();
	
	//ノート情報追加
	int AddNote(SMNote note);
	
	//ノート情報取得
	int GetNote(unsigned int index, SMNote* pNote);
	
	//ノート情報登録（上書き）
	int SetNote(unsigned int index, SMNote* pNote);
	
	//ノート数取得
	unsigned int GetSize();
	
	//コピー
	int CopyFrom(SMNoteList* pSrcList);
	
private:
	
	SMSimpleList m_List;
	
	//代入とコピーコンストラクタの禁止
	void operator=(const SMNoteList&);
	SMNoteList(const SMNoteList&);

};


