/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import jp.sfjp.mikutoga.pmd.model.SerialNumbered;

public final class ListUtil {
    private ListUtil() {
        assert (false);
        throw new AssertionError();
    }

    public static void assignIndexedSerial(List<? extends SerialNumbered> list) {
        int serial = 0;
        for (SerialNumbered serialNumbered : list) {
            serialNumbered.setSerialNumber(serial);
            ++serial;
        }
    }

    public static <E> void extendList(List<E> list, int newSize) {
        int remain = newSize - list.size();
        if (remain <= 0) {
            return;
        }
        for (int ct = 1; ct <= remain; ++ct) {
            list.add(null);
        }
        assert (list.size() == newSize);
    }

    public static <E> int fillDefCons(List<E> list, Constructor<? extends E> cons) {
        int result = 0;
        int size = list.size();
        for (int pt = 0; pt < size; ++pt) {
            E elem = list.get(pt);
            if (elem != null) continue;
            try {
                elem = cons.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                assert (false);
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                assert (false);
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                assert (false);
                throw new AssertionError((Object)e);
            }
            list.set(pt, elem);
            ++result;
        }
        return result;
    }

    public static <E> int fillDefCons(List<E> list, Class<? extends E> klass) {
        Constructor<? extends E> cons;
        try {
            cons = klass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return ListUtil.fillDefCons(list, cons);
    }

    public static <E> int prepareDefConsList(List<E> list, Class<? extends E> klass, int newSize) {
        ListUtil.extendList(list, newSize);
        int result = ListUtil.fillDefCons(list, klass);
        return result;
    }
}

