/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.model;

import java.util.Comparator;
import jp.sfjp.mikutoga.pmd.model.SerialNumbered;
import jp.sfjp.mikutoga.pmd.model.Vertex;
import jp.sourceforge.mikutoga.math.MkPos3D;

public class MorphVertex
implements SerialNumbered {
    public static final Comparator<MorphVertex> VIDCOMPARATOR = new VertexIdComparator();
    private Vertex baseVertex;
    private final MkPos3D offset = new MkPos3D();
    private int serialNo = -1;

    public Vertex getBaseVertex() {
        return this.baseVertex;
    }

    public void setBaseVertex(Vertex vertex) throws NullPointerException {
        if (vertex == null) {
            throw new NullPointerException();
        }
        this.baseVertex = vertex;
    }

    public MkPos3D getOffset() {
        return this.offset;
    }

    @Override
    public void setSerialNumber(int num) {
        this.serialNo = num;
    }

    @Override
    public int getSerialNumber() {
        return this.serialNo;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("vid(").append(this.baseVertex.getSerialNumber()).append(") ");
        result.append(this.baseVertex.getPosition());
        result.append(" >> ");
        result.append(this.offset);
        return result.toString();
    }

    private static final class VertexIdComparator
    implements Comparator<MorphVertex> {
        private VertexIdComparator() {
        }

        @Override
        public int compare(MorphVertex o1, MorphVertex o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int ser1 = o1.getBaseVertex().getSerialNumber();
            int ser2 = o2.getBaseVertex().getSerialNumber();
            return ser1 - ser2;
        }
    }
}

