/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.xml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import jp.sfjp.mikutoga.pmd.xml.BotherHandler;
import jp.sourceforge.mikutoga.xml.XmlResourceResolver;
import org.xml.sax.SAXException;

public abstract class LocalSchema {
    protected LocalSchema() {
    }

    private static SchemaFactory newSchemaFactory() {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(BotherHandler.HANDLER);
        return schemaFactory;
    }

    public static Schema newSchema(XmlResourceResolver resolver, LocalSchema ... lscs) {
        Schema result;
        LinkedList<Source> sourceList = new LinkedList<Source>();
        for (LocalSchema lsc : lscs) {
            if (lsc == null) continue;
            lsc.appendToUriMap(resolver);
            Source local = lsc.getLocalSchemaSource();
            if (local == null) continue;
            sourceList.add(local);
        }
        SchemaFactory schemaFactory = LocalSchema.newSchemaFactory();
        schemaFactory.setResourceResolver(resolver);
        Source[] sources = new Source[sourceList.size()];
        sourceList.toArray(sources);
        try {
            result = sources.length <= 0 ? schemaFactory.newSchema() : schemaFactory.newSchema(sources);
        }
        catch (SAXException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public abstract URI getOriginalSchema();

    public abstract URI getLocalSchema();

    public Source getLocalSchemaSource() {
        InputStream is;
        URL url;
        URI uri = this.getLocalSchema();
        if (uri == null) {
            return null;
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            assert (false);
            throw new AssertionError((Object)e);
        }
        is = new BufferedInputStream(is);
        StreamSource result = new StreamSource(is);
        return result;
    }

    public void appendToUriMap(XmlResourceResolver resolver) {
        URI original = this.getOriginalSchema();
        URI local = this.getLocalSchema();
        if (original == null) {
            return;
        }
        resolver.putRedirected(original, local);
    }
}

