/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mikutoga.parser.MmdEofException;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.parser.TextDecoder;

public class CommonParser {
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_FLOAT = 4;
    private static final int BYTES_PRIM = 4;
    private static final int MASK_8BIT = 255;
    private static final int MASK_16BIT = 65535;
    private final PushbackInputStream is;
    private final byte[] readBuffer;
    private final ByteBuffer beBuf;
    private final ByteBuffer leBuf;
    private long position = 0L;

    public CommonParser(InputStream source) {
        this.is = new PushbackInputStream(source, 1);
        this.readBuffer = new byte[4];
        this.beBuf = ByteBuffer.wrap(this.readBuffer);
        this.leBuf = ByteBuffer.wrap(this.readBuffer);
        this.beBuf.order(ByteOrder.BIG_ENDIAN);
        this.leBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    protected long getPosition() {
        long result = this.position;
        return result;
    }

    public boolean hasMore() throws IOException {
        int bVal;
        try {
            bVal = this.is.read();
        }
        catch (EOFException e) {
            return false;
        }
        if (bVal < 0) {
            return false;
        }
        this.is.unread(bVal);
        return true;
    }

    protected void skip(long skipLength) throws IOException, MmdEofException {
        long remain = skipLength;
        while (remain > 0L) {
            long txSize = this.is.skip(remain);
            if (txSize <= 0L) {
                throw new MmdEofException(this.position);
            }
            remain -= txSize;
            this.position += txSize;
        }
    }

    protected void parseByteArray(byte[] dst, int off, int length) throws IOException, NullPointerException, IndexOutOfBoundsException, MmdEofException {
        int remain = length;
        int offset = off;
        while (remain > 0) {
            int txSize = this.is.read(dst, offset, remain);
            if (txSize <= 0) {
                throw new MmdEofException(this.position);
            }
            remain -= txSize;
            offset += txSize;
            this.position += (long)txSize;
        }
    }

    protected void parseByteArray(byte[] dst) throws IOException, NullPointerException, MmdEofException {
        this.parseByteArray(dst, 0, dst.length);
    }

    private void fillBuffer(int fillSize) throws IOException, MmdEofException {
        this.parseByteArray(this.readBuffer, 0, fillSize);
    }

    protected byte parseByte() throws IOException, MmdEofException {
        int bData = this.is.read();
        if (bData < 0) {
            throw new MmdEofException(this.position);
        }
        byte result = (byte)bData;
        ++this.position;
        return result;
    }

    protected int parseUByteAsInt() throws IOException, MmdEofException {
        return this.parseByte() & 0xFF;
    }

    protected boolean parseBoolean() throws IOException, MmdEofException {
        byte result = this.parseByte();
        return result != 0;
    }

    protected short parseLeShort() throws IOException, MmdEofException {
        this.fillBuffer(2);
        short result = this.leBuf.getShort(0);
        return result;
    }

    protected int parseLeUShortAsInt() throws IOException, MmdEofException {
        return this.parseLeShort() & 0xFFFF;
    }

    protected int parseLeInt() throws IOException, MmdEofException {
        this.fillBuffer(4);
        int result = this.leBuf.getInt(0);
        return result;
    }

    protected float parseLeFloat() throws IOException, MmdEofException {
        this.fillBuffer(4);
        float result = this.leBuf.getFloat(0);
        return result;
    }

    protected String parseString(TextDecoder decoder, int byteLen) throws IOException, MmdEofException, MmdFormatException {
        byte[] buf = decoder.prepareBuffer(byteLen);
        this.parseByteArray(buf, 0, byteLen);
        long basePos = this.getPosition();
        String result = decoder.decode(basePos, byteLen);
        return result;
    }
}

