/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mikutoga.pmd.parser;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.mikutoga.parser.MmdFormatException;
import jp.sourceforge.mikutoga.pmd.parser.PmdJointHandler;
import jp.sourceforge.mikutoga.pmd.parser.PmdParserExt2;
import jp.sourceforge.mikutoga.pmd.parser.PmdRigidHandler;

public class PmdParserExt3
extends PmdParserExt2 {
    private static final int RIGID_DATA_SZ = 83;
    private static final int JOINT_DATA_SZ = 124;
    private PmdRigidHandler rigidHandler = null;
    private PmdJointHandler jointHandler = null;

    public PmdParserExt3(InputStream source) {
        super(source);
    }

    public void setRigidHandler(PmdRigidHandler handler) {
        this.rigidHandler = handler;
    }

    public void setJointHandler(PmdJointHandler handler) {
        this.jointHandler = handler;
    }

    @Override
    protected void parseBody() throws IOException, MmdFormatException {
        super.parseBody();
        if (this.hasMore()) {
            this.parseRigidList();
            this.parseJointList();
        }
    }

    private void parseRigidList() throws IOException, MmdFormatException {
        int rigidNum = this.parseLeInt();
        if (this.rigidHandler == null) {
            this.skip(83 * rigidNum);
            return;
        }
        this.rigidHandler.loopStart(PmdRigidHandler.RIGID_LIST, rigidNum);
        for (int ct = 0; ct < rigidNum; ++ct) {
            String rigidName = this.parsePmdText(20);
            this.rigidHandler.pmdRigidName(rigidName);
            int linkedBoneId = this.parseLeUShortAsInt();
            int rigidGroupId = this.parseUByteAsInt();
            short collisionMap = this.parseLeShort();
            this.rigidHandler.pmdRigidInfo(rigidGroupId, linkedBoneId);
            byte shapeType = this.parseByte();
            float width = this.parseLeFloat();
            float height = this.parseLeFloat();
            float depth = this.parseLeFloat();
            this.rigidHandler.pmdRigidShape(shapeType, width, height, depth);
            float posX = this.parseLeFloat();
            float posY = this.parseLeFloat();
            float posZ = this.parseLeFloat();
            this.rigidHandler.pmdRigidPosition(posX, posY, posZ);
            float rotX = this.parseLeFloat();
            float rotY = this.parseLeFloat();
            float rotZ = this.parseLeFloat();
            this.rigidHandler.pmdRigidRotation(rotX, rotY, rotZ);
            float mass = this.parseLeFloat();
            float dampingPos = this.parseLeFloat();
            float dampingRot = this.parseLeFloat();
            float restitution = this.parseLeFloat();
            float friction = this.parseLeFloat();
            this.rigidHandler.pmdRigidPhysics(mass, dampingPos, dampingRot, restitution, friction);
            byte behaveType = this.parseByte();
            this.rigidHandler.pmdRigidBehavior(behaveType, collisionMap);
            this.rigidHandler.loopNext(PmdRigidHandler.RIGID_LIST);
        }
        this.rigidHandler.loopEnd(PmdRigidHandler.RIGID_LIST);
    }

    private void parseJointList() throws IOException, MmdFormatException {
        int jointNum = this.parseLeInt();
        if (this.jointHandler == null) {
            this.skip(124 * jointNum);
            return;
        }
        this.jointHandler.loopStart(PmdJointHandler.JOINT_LIST, jointNum);
        for (int ct = 0; ct < jointNum; ++ct) {
            String jointName = this.parsePmdText(20);
            this.jointHandler.pmdJointName(jointName);
            int rigidIdA = this.parseLeInt();
            int rigidIdB = this.parseLeInt();
            this.jointHandler.pmdJointLink(rigidIdA, rigidIdB);
            float posX = this.parseLeFloat();
            float posY = this.parseLeFloat();
            float posZ = this.parseLeFloat();
            this.jointHandler.pmdJointPosition(posX, posY, posZ);
            float rotX = this.parseLeFloat();
            float rotY = this.parseLeFloat();
            float rotZ = this.parseLeFloat();
            this.jointHandler.pmdJointRotation(rotX, rotY, rotZ);
            float posXlim1 = this.parseLeFloat();
            float posYlim1 = this.parseLeFloat();
            float posZlim1 = this.parseLeFloat();
            float posXlim2 = this.parseLeFloat();
            float posYlim2 = this.parseLeFloat();
            float posZlim2 = this.parseLeFloat();
            this.jointHandler.pmdPositionLimit(posXlim1, posXlim2, posYlim1, posYlim2, posZlim1, posZlim2);
            float rotXlim1 = this.parseLeFloat();
            float rotYlim1 = this.parseLeFloat();
            float rotZlim1 = this.parseLeFloat();
            float rotXlim2 = this.parseLeFloat();
            float rotYlim2 = this.parseLeFloat();
            float rotZlim2 = this.parseLeFloat();
            this.jointHandler.pmdRotationLimit(rotXlim1, rotXlim2, rotYlim1, rotYlim2, rotZlim1, rotZlim2);
            float elasticPosX = this.parseLeFloat();
            float elasticPosY = this.parseLeFloat();
            float elasticPosZ = this.parseLeFloat();
            this.jointHandler.pmdElasticPosition(elasticPosX, elasticPosY, elasticPosZ);
            float elasticRotX = this.parseLeFloat();
            float elasticRotY = this.parseLeFloat();
            float elasticRotZ = this.parseLeFloat();
            this.jointHandler.pmdElasticRotation(elasticRotX, elasticRotY, elasticRotZ);
            this.jointHandler.loopNext(PmdJointHandler.JOINT_LIST);
        }
        this.jointHandler.loopEnd(PmdJointHandler.JOINT_LIST);
    }
}

