<?php
//  ------------------------------------------------------------------------ //
//                      TimeCard System Module for                           //
//               XOOPS - PHP Content Management System 2.0                   //
//                            Version 0.1                                    //
//                   Copyright (c) 2004 mikkun                               //
//                       http://habboportal.com/                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

class TimecardData {
	var $errorCode;	//顼
	var $userID;
	var $month;
	var $period;
	var $affiliation;
	var $shift;
	var $dataRows;
	var $fetchSumData;
	var $fetchData;
	var $where;
	var $affiliateIDList;
	var $shiftIDList;
		
	function TimecardData($UserID,$Affiliation,$Period=31,$Month='',$Shift=0) {
		$this->errorCode = 0;
		$this->dataRows = 0;
		$this->affiliateIDList = array();
		$this->shiftIDList = array();
		$this->fetchData = array();
		$this->fetchSumData = 0;
		$this->setConditions($UserID,$Affiliation,$Period,$Month,$Shift);
		$this->query();
	}
	
	function setConditions($UserID,$Affiliation,$Period=31,$Month='',$Shift=0) {
		$this->errorCode = 0;
		$this->userID = $UserID;
		if($Month == '') {
			$this->month = formatTimestamp(time(),"Y/m/d");
		} else {
			$this->month =$Month;
		}
		$this->period = $Period;
		$this->shift = $Shift;
		$this->affiliation = $Affiliation;

		//դΥॹפؤѴ
		$startTimeStamp = strtotime($this->month);
		if ($startTimeStamp == -1) {
			$this->errorCode = -1;
			return ($this->errorCode = -1);			
		}
		//λդΥॹפη׻
		$EndDayTimeStamp = (86400*$Period)+$startTimeStamp;		

		//SQL WHERE
		$this->where = ' WHERE timedata.uid='.$this->userID;
		if(is_array($this->affiliation)) {
			
			$i = 0;
			$this->where = $this->where.' AND (timedata.AffiliationID='.$this->affiliation[$i];
			for($i = 1;$i < count($this->affiliation);$i++) {
				$this->where = $this->where.' or timedata.AffiliationID='.$this->affiliation[$i];
			}
			$this->where = $this->where.')';
		} else {

			if($this->affiliation != 0) {
				$this->where = $this->where.' AND timedata.AffiliationID='.$this->affiliation;
			}
		}
		if(is_array($this->shift) == false) {

			if($this->shift != 0) {
				$this->where = $this->where.' AND shift.ShiftID='.$this->shift;
			}
		}else {

			$i = 0;
			$this->where = $this->where.' AND (shift.ShiftID='.$this->shift[$i];
			for($i = 1;$i < count($this->shift);$i++) {
				$this->where = $this->where.' or shift.ShiftID='.$this->shift[$i];
			}
			$this->where = $this->where.')';
		}
		if($this->period != 0) {
			$this->where = $this->where.' AND timedata.Date Between '.$startTimeStamp.' And '.$EndDayTimeStamp;
		} else {
			$this->where = $this->where.' AND timedata.Date='.$startTimeStamp;
		}
	}
/*
SELECT timecard_timedata.*, timecard_affiliation.AffiliationID, timecard_affiliation.AffiliationName, timecard_categories.CategoryID, timecard_categories.CategoryName, timecard_company.CompanyID, timecard_company.CompanyName, timecard_projects.ProjectID, timecard_projects.ProjectName, timecard_shifts.ShiftID, timecard_shifts.ShiftName
FROM ((((timecard_timedata INNER JOIN timecard_affiliation ON timecard_timedata.AffiliationID = timecard_affiliation.AffiliationID) INNER JOIN timecard_categories ON timecard_affiliation.CategoryID = timecard_categories.CategoryID) INNER JOIN timecard_company ON timecard_affiliation.CompanyID = timecard_company.CompanyID) INNER JOIN timecard_projects ON timecard_affiliation.ProjectID = timecard_projects.ProjectID) INNER JOIN timecard_shifts ON timecard_affiliation.ShiftID = timecard_shifts.ShiftID;
*/	
	function query() {
		global $xoopsDB;
		$this->errorCode = 0;
		$sql = 'SELECT timedata.*,affiliation.AffiliationID, affiliation.AffiliationName,categories.CategoryID,categories.CategoryName,company.CompanyID,company.CompanyName,projects.ProjectID,projects.ProjectName,shifts.ShiftID,shifts.ShiftName ';
		$sql = $sql.'FROM (((('.$xoopsDB->prefix('timecard_timedata').' timedata ';
		$sql = $sql.'INNER JOIN '.$xoopsDB->prefix('timecard_affiliation').' affiliation ON timedata.AffiliationID = affiliation.AffiliationID) ';
		$sql = $sql.'INNER JOIN '.$xoopsDB->prefix('timecard_categories').' categories ON affiliation.CategoryID = categories.CategoryID) ';
		$sql = $sql.'INNER JOIN '.$xoopsDB->prefix('timecard_company').' company ON affiliation.CompanyID = company.CompanyID) ';
		$sql = $sql.'INNER JOIN '.$xoopsDB->prefix('timecard_projects').' projects ON affiliation.ProjectID = projects.ProjectID) ';
		$sql = $sql.'INNER JOIN '.$xoopsDB->prefix('timecard_shifts').' shifts ON affiliation.ShiftID = shifts.ShiftID';
		$sql = $sql.$this->where;

		if ( !$result = $xoopsDB->query($sql) ) {
			$this->errorCode = -2;
			return $this->errorCode;
		}
	
		$this->dataRows = $xoopsDB->getRowsNum($result);
		if($this->dataRows == 0) {
			return 0;
		}
	
		//ѿν
		$holidayCounter = 0;		//
		$latenessCounter = 0;		//ٹ
		$absenceCounter = 0;		//
		$leavingEearlyCounter = 0;	//
	
		//׻֤ν
		$goOutTimeSum1 = 0;
		$goOutTimeSum2 = 0;
		$goOutTimeSum3 = 0;
		$officeHoursSum = 0;
		$earlyAttendanceSum = 0;
		$overtimeWorkSum = 0;
		$midnightOvertimeWorkSum = 0;

		//ǡΥեå
		$i = 0;
		$affiliationID = array();
		$shiftID = array();
		while ( $myrow = $xoopsDB->fetchArray($result) ) {
			if($myrow['GoTime'] != 0) {		//жл
				$goTime = ' ' .formatTimestamp($myrow['GoTime'],"H:i").' ';
			} else {
				$goTime = '';
			}
			if($myrow['LthTime'] != 0) {	//л
				$lthTime =  ' ' .formatTimestamp($myrow['LthTime'],"H:i").' ';
			} else {
				$lthTime = '';
			}
			if($myrow['GoOutTime1'] != 0) {	//1ϻ
				$goOutTime1 = formatTimestamp($myrow['GoOutTime1'],"H:i");
			} else {
				$goOutTime1 = '';
			}
			if($myrow['GoOutInTime1'] != 0) {//1λ
				$goOutInTime1 = formatTimestamp($myrow['GoOutInTime1'],"H:i");
				//׻֤η׻
				$goOutTimeSum1 += $myrow['GoOutInTime1']-$myrow['GoOutTime1'];
			} else {
				$goOutInTime1 = '';
			}
			if($myrow['GoOutTime2'] != 0) {	//2ϻ
				$goOutTime2 = formatTimestamp($myrow['GoOutTime2'],"H:i");
			} else {
				$goOutTime2 = '';
			}
			if($myrow['GoOutInTime2'] != 0) {//2λ
				$goOutInTime2 = formatTimestamp($myrow['GoOutInTime2'],"H:i");
				//׻֤η׻
				$goOutTimeSum2 += $myrow['GoOutInTime2']-$myrow['GoOutTime2'];
			} else {
				$goOutInTime2 = '';
			}
			if($myrow['GoOutTime3'] != 0) {	//3ϻ
				$goOutTime3 = formatTimestamp($myrow['GoOutTime3'],"H:i");
			} else {
				$goOutTime3 = '';
			}
			if($myrow['GoOutInTime3'] != 0) {//3λ
				$goOutInTime3 = formatTimestamp($myrow['GoOutInTime3'],"H:i");
				//׻֤η׻
				$goOutTimeSum3 += $myrow['GoOutInTime3']-$myrow['GoOutTime3'];
			} else {
				$goOutInTime3 = '';
			}
			if($myrow['KinmuTime'] != 0) {//̳
				$officeHours = getTimeEx2($myrow['KinmuTime']);
				//׻֤η׻
				$officeHoursSum += $myrow['KinmuTime'];
			} else {
				$officeHours = getTimeEx2(0);
			}
			if($myrow['HayadeTime'] != 0) {//л
				$earlyAttendance = getTimeEx2($myrow['HayadeTime']);
				//׻֤η׻
				$earlyAttendanceSum += $myrow['HayadeTime'];
			} else {
				$earlyAttendance = getTimeEx2(0);
			}
			if($myrow['ZangyoTime'] != 0) {//ĶȻ
				$overtimeWork = getTimeEx2($myrow['ZangyoTime']);
				//׻֤η׻
				$overtimeWorkSum += $myrow['ZangyoTime'];
			} else {
				$overtimeWork = getTimeEx2(0);
			}
			if($myrow['ShinyaZangyoTime'] != 0) {//ĶȻ
				$midnightOvertimeWork = getTimeEx2($myrow['ShinyaZangyoTime']);
				//׻֤η׻
				$midnightOvertimeWorkSum += $myrow['ShinyaZangyoTime'];
			} else {
				$midnightOvertimeWork = getTimeEx2(0);
			}
		
		//󥿤
			if($myrow['KyuzituFrag'] != 0) {
				$holidayCounter++;
			}
			if($myrow['TikokuFrag'] != 0) {
				$latenessCounter++;
			}
			if($myrow['KekkinFrag'] != 0) {
				$absenceCounter++;
			}
			if($myrow['SoutaiFrag'] != 0) {
				$leavingEearlyCounter++;
			}
			$this->affiliateIDList[$i+1] = $myrow['AffiliationID'];
			$this->shiftIDList[$i+1] = $myrow['ShiftID'];
		    $this->fetchData[$i] = array('date'=>formatTimestamp($myrow['Date'],"m-d"),'shift'=>$myrow['ShiftName'],'syukin'=>$goTime,'taikin'=>$lthTime,'gaisyutu1start'=>$goOutTime1,'gaisyutu1end'=>$goOutInTime1,'gaisyutu2start'=>$goOutTime2,'gaisyutu2end'=>$goOutInTime2,'gaisyutu3start'=>$goOutTime3,'gaisyutu3end'=>$goOutInTime3,'kinmuzikan'=>$officeHours,'hayade'=>$earlyAttendance,'zangyo'=>$overtimeWork,'sinyazangyo'=>$midnightOvertimeWork,'timedataid'=>$myrow['TimeDataID'],'tikokufrag'=>$myrow['TikokuFrag'],'soutaifrag'=>$myrow['SoutaiFrag'],'kyuzitufrag'=>$myrow['KyuzituFrag'],'kekkinfrag'=>$myrow['KekkinFrag'],'bikou'=>$myrow['ExtraInfo']);
			$i++;
		}
		$this->fetchSumData = array('leavingEearlyCounter'=>$leavingEearlyCounter,'absenceCounter'=>$absenceCounter,'latenessCounter'=>$latenessCounter,'holidayCounter'=>$holidayCounter,'goOutTimeSum1'=>$goOutTimeSum1,'goOutTimeSum2' =>$goOutTimeSum2,'goOutTimeSum3' =>$goOutTimeSum3,'officeHoursSum'=>$officeHoursSum,'earlyAttendanceSum' =>$earlyAttendanceSum,'overtimeWorkSum' =>$overtimeWorkSum,'midnightOvertimeWorkSum' =>$midnightOvertimeWorkSum);
		return 0;
	}
}
?>