/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class PSC {
    static String[] target = null;
    static String ploneDir = null;
    static String proxyHost = null;
    static String proxyPort = "8080";
    static String command = null;
    static Hashtable<String, String[]> account = null;
    static int timeTolerance = 60000;
    static int safetyMargin = 10000;
    static boolean recursiveF = false;
    static boolean addF = false;
    static boolean removeF = false;
    static boolean prudenceF = false;
    static boolean confirmF = true;

    static void init() throws Exception {
        StringTokenizer st;
        String s;
        BufferedReader br;
        FileReader fr;
        LFile f = new LFile(System.getProperty("user.home") + "/.PloneSync");
        if (f.exists() && f.isFile()) {
            System.err.println("config file error!");
            System.exit(0);
        }
        if (!f.exists()) {
            f.mkdir();
        }
        account = new Hashtable();
        f = new LFile(System.getProperty("user.home") + "/.PloneSync/auth");
        if (f.isFile()) {
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            s = null;
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).startsWith("#")) continue;
                st = new StringTokenizer(s);
                String[] up = new String[]{st.nextToken().trim(), st.nextToken().trim()};
                String url = st.nextToken().trim();
                account.put(url, up);
            }
        }
        if ((f = new LFile(System.getProperty("user.home") + "/.PloneSync/proxy")).isFile()) {
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            s = null;
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).startsWith("#")) continue;
                if (s.startsWith("host")) {
                    st = new StringTokenizer(s, "=");
                    st.nextToken();
                    proxyHost = st.nextToken().trim();
                    continue;
                }
                if (!s.startsWith("port")) continue;
                st = new StringTokenizer(s, "=");
                st.nextToken();
                proxyPort = st.nextToken().trim();
            }
        }
        if (proxyHost != null) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("proxyHost", proxyHost);
            System.getProperties().put("proxyPort", proxyPort);
        }
    }

    static void parseArgs(String[] args) throws PFileException {
        if (args.length == 0) {
            PSC.printUsageAndExit();
        }
        if (args[0].equals("login")) {
            PSC.login(args);
        } else if (args[0].equals("logout")) {
            PSC.logout(args);
        } else if (args[0].equals("checkout")) {
            PSC.checkout(args);
        } else if (args[0].equals("import")) {
            PSC.import_(args);
        } else if (args[0].equals("commit")) {
            PSC.commit(args);
        } else if (args[0].equals("update")) {
            PSC.update(args);
        } else if (args[0].equals("add")) {
            PSC.add(args);
        } else if (args[0].equals("remove")) {
            PSC.remove(args);
        } else if (args[0].equals("abandon")) {
            PSC.abandon(args);
        } else if (args[0].equals("force")) {
            PSC.force(args);
        } else if (args[0].equals("diff")) {
            PSC.diff(args);
        } else if (args[0].equals("sync")) {
            PSC.sync(args);
        } else {
            PSC.printUsageAndExit();
        }
    }

    static void printUsageAndExit() {
        System.out.println("USAGE: java PSC command [args...]");
        System.out.println();
        System.out.println("commands are...");
        System.out.println("    login plone_dir");
        System.out.println("    logout plone_dir");
        System.out.println("    checkout plone_dir");
        System.out.println("    import dir plone_dir");
        System.out.println("    commit [files or dirs]");
        System.out.println("    update [files or dirs]");
        System.out.println("    add [files or dirs]");
        System.out.println("    remove [files or dirs]");
        System.out.println("    abandon [files or dirs]");
        System.out.println("    force [files or dirs]");
        System.out.println("    diff [files or dirs]");
        System.out.println("    sync [option option ...]");
        System.out.println("        sync options are...");
        System.out.println("        -s : recursive sync. (Subfolder)");
        System.out.println("        -a : automatic Add.");
        System.out.println("        -r : automatic Remove.");
        System.out.println("        -p : do not delete. (Prudence)");
        System.out.println("        -f : do not confirm. (Force)");
        System.out.println();
        System.out.println("If you need to access a SSL server using");
        System.out.println("a Self-Signed certification authority,");
        System.out.println("use keytool command to install it.");
        System.exit(0);
    }

    static void initPFile(String url) throws PFileException {
        int maxLength = 0;
        String targetURL = null;
        Enumeration<String> e = account.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            if (!url.startsWith(s) || s.length() <= maxLength) continue;
            maxLength = s.length();
            targetURL = s;
        }
        if (targetURL != null) {
            String[] up = account.get(targetURL);
            PFile.init(url, up[0], up[1]);
        } else {
            PFile.init(url, null, null);
        }
        long localTime = System.currentTimeMillis();
        long remoteTime = PFile.siteCurrentTime();
        if (Math.abs(localTime - remoteTime) > (long)timeTolerance) {
            System.out.println("local:" + localTime);
            System.out.println("remote:" + remoteTime);
            System.out.println("ERROR: set time correctly.");
            System.exit(-1);
        }
    }

    static void login(String[] args) {
        try {
            if (args.length != 2) {
                PSC.printUsageAndExit();
            }
            String site = args[1];
            while (site.endsWith("/")) {
                site = site.substring(0, site.length() - 1);
            }
            if (account.get(site) != null) {
                System.out.println("You had already logged in.");
                System.exit(-1);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String[] up = new String[2];
            System.out.print("username: ");
            up[0] = br.readLine();
            System.out.print("password: ");
            up[1] = br.readLine();
            account.put(site, up);
            LFile f = new LFile(System.getProperty("user.home") + "/.PloneSync/auth");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Enumeration<String> e = account.keys();
            while (e.hasMoreElements()) {
                String url = e.nextElement();
                up = account.get(url);
                bw.write(up[0] + " " + up[1] + " " + url + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void logout(String[] args) {
        try {
            if (args.length != 2) {
                PSC.printUsageAndExit();
            }
            if (account.get(args[1]) == null) {
                System.out.println("You had not logged in.");
                System.exit(-1);
            }
            account.remove(args[1]);
            LFile f = new LFile(System.getProperty("user.home") + "/.PloneSync/auth");
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Enumeration<String> e = account.keys();
            while (e.hasMoreElements()) {
                String url = e.nextElement();
                String[] up = account.get(url);
                bw.write(up[0] + " " + up[1] + " " + url + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void checkout(String[] args) {
        try {
            LFile lf;
            if (args.length != 2) {
                PSC.printUsageAndExit();
            }
            PSC.initPFile(args[1]);
            PFile pf = new PFile(args[1]);
            if (!pf.isDirectory()) {
                PSC.printUsageAndExit();
            }
            if ((lf = new LFile(System.getProperty("user.dir") + "/" + pf.getName())).exists()) {
                System.out.println("local " + pf.getName() + " has already exist");
            }
            lf.mkdir();
            lf.setSite(pf.url);
            PSC.checkoutR(pf, lf);
        }
        catch (PFileException e) {
            e.printStackTrace();
        }
    }

    static void checkoutR(PFile pf, LFile lf) {
        try {
            PFile[] pfs = pf.listFiles();
            for (int i = 0; i < pfs.length; ++i) {
                LFile f;
                if (pfs[i].isFile()) {
                    f = new LFile(lf, pfs[i].getName());
                    if (PSC.get(pfs[i], f)) {
                        System.out.println("get: " + f.getName());
                        continue;
                    }
                    System.out.println("get error?: " + f.getName());
                    continue;
                }
                f = new LFile(lf, pfs[i].getName());
                f.mkdir();
                f.setSite(pfs[i].url);
                f.setStatus(LFile.Status.SYNCED);
                System.out.println("get: " + f.getName());
                PSC.checkoutR(pfs[i], f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void import_(String[] args) {
        try {
            LFile lf;
            if (args.length != 3) {
                PSC.printUsageAndExit();
            }
            if (!(lf = new LFile(args[1])).isDirectory()) {
                PSC.printUsageAndExit();
            }
            PSC.initPFile(args[2]);
            PFile pf = new PFile(args[2]);
            if (!pf.isDirectory()) {
                PSC.printUsageAndExit();
            }
            PSC.import_R(pf, lf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void import_R(PFile pf, LFile lf) {
        try {
            LFile[] lfs = lf.listFiles();
            for (int i = 0; i < lfs.length; ++i) {
                PFile f;
                if (lfs[i].isFile()) {
                    f = new PFile(pf, lfs[i].getName());
                    PSC.put(f, lfs[i]);
                    continue;
                }
                f = new PFile(pf, lfs[i].getName());
                f.mkdir();
                PSC.import_R(f, lfs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void commit(String[] args) {
        System.out.println("PSC.commit(). not implemented yet!");
    }

    static void update(String[] args) {
        System.out.println("PSC.update(). not implemented yet!");
    }

    static void add(String[] args) {
        int i;
        LFile lf;
        String site;
        if (args.length < 2) {
            PSC.printUsageAndExit();
        }
        if ((site = (lf = new LFile(System.getProperty("user.dir"))).getSite()) == null) {
            System.out.println("ERROR: Current dir is not psc synced.");
            System.exit(-1);
        }
        LFile[] lfs = new LFile[args.length - 1];
        for (i = 1; i < args.length; ++i) {
            lfs[i - 1] = new LFile(lf, args[i]);
        }
        for (i = 0; i < lfs.length; ++i) {
            PSC.addR(lfs[i]);
        }
    }

    static void addR(LFile lf) {
        if (!lf.exists()) {
            System.out.println("ERROR: There is not file(" + lf.getName() + ").");
            return;
        }
        if (lf.existsInEntries() && lf.getStatus() != LFile.Status.REMOVED) {
            System.out.println("ERROR: file(" + lf.getName() + ") has already added.");
            return;
        }
        lf.setStatus(LFile.Status.ADDED);
        lf.setEntryTime(System.currentTimeMillis());
        System.out.println("Add file(" + lf.getName() + ").");
        if (lf.isDirectory()) {
            LFile parent = lf.getParentFile();
            String site = parent.getSite() + "/" + lf.getName();
            lf.setSite(site);
            LFile[] lfs = lf.listFiles();
            for (int i = 0; i < lfs.length; ++i) {
                PSC.addR(lfs[i]);
            }
        }
    }

    static void remove(String[] args) {
        LFile lf;
        String site;
        if (args.length < 2) {
            PSC.printUsageAndExit();
        }
        if ((site = (lf = new LFile(System.getProperty("user.dir"))).getSite()) == null) {
            System.out.println("ERROR: Current dir is not psc synced.");
            System.exit(-1);
        }
        LFile[] lfs = new LFile[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            lfs[i - 1] = new LFile(lf, args[i]);
        }
        PSC.remove2(lfs);
    }

    static void remove2(LFile[] lfs) {
        int i;
        for (i = 0; i < lfs.length; ++i) {
            if (!lfs[i].exists()) continue;
            System.out.println("ERROR: There is file(" + lfs[i].getName() + ").");
            System.exit(-1);
        }
        for (i = 0; i < lfs.length; ++i) {
            if (lfs[i].existsInEntries()) continue;
            System.out.println("ERROR: file(" + lfs[i].getName() + ") has not added.");
            System.exit(-1);
        }
        for (i = 0; i < lfs.length; ++i) {
            lfs[i].setStatus(LFile.Status.REMOVED);
            lfs[i].setEntryTime(System.currentTimeMillis());
            System.out.println("Remove file(" + lfs[i].getName() + ").");
        }
    }

    static void abandon(String[] args) {
        int i;
        LFile lf;
        String site;
        if (args.length < 2) {
            PSC.printUsageAndExit();
        }
        if ((site = (lf = new LFile(System.getProperty("user.dir"))).getSite()) == null) {
            System.out.println("ERROR: Current dir is not psc synced.");
            System.exit(-1);
        }
        LFile[] lfs = new LFile[args.length - 1];
        for (i = 1; i < args.length; ++i) {
            lfs[i - 1] = new LFile(lf, args[i]);
        }
        for (i = 0; i < lfs.length; ++i) {
            if (lfs[i].getStatus() != LFile.Status.CONFLICT) {
                System.out.println("skip: " + lfs[i].getName() + " is not conflict.");
                continue;
            }
            lfs[i].setStatus(LFile.Status.ABANDON);
            System.out.println("abandon: " + lfs[i].getName());
        }
    }

    static void force(String[] args) {
        int i;
        LFile lf;
        String site;
        if (args.length < 2) {
            PSC.printUsageAndExit();
        }
        if ((site = (lf = new LFile(System.getProperty("user.dir"))).getSite()) == null) {
            System.out.println("ERROR: Current dir is not psc synced.");
            System.exit(-1);
        }
        LFile[] lfs = new LFile[args.length - 1];
        for (i = 1; i < args.length; ++i) {
            lfs[i - 1] = new LFile(lf, args[i]);
        }
        for (i = 0; i < lfs.length; ++i) {
            if (lfs[i].getStatus() != LFile.Status.CONFLICT) {
                System.out.println("skip: " + lfs[i].getName() + " is not conflict.");
                continue;
            }
            lfs[i].setStatus(LFile.Status.FORCED);
            System.out.println("forced: " + lfs[i].getName());
        }
    }

    static void diff(String[] args) {
        System.out.println("PSC.diff(). not implemented yet!");
    }

    static void sync(String[] args) throws PFileException {
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-s")) {
                recursiveF = true;
                continue;
            }
            if (args[i].equals("-a")) {
                addF = true;
                continue;
            }
            if (args[i].equals("-r")) {
                removeF = true;
                continue;
            }
            if (args[i].equals("-p")) {
                prudenceF = true;
                continue;
            }
            if (args[i].equals("-f")) {
                confirmF = false;
                continue;
            }
            System.out.println("no such option(" + args[i] + ").");
            System.exit(-1);
        }
        LFile lf = new LFile(System.getProperty("user.dir"));
        String site = lf.getSite();
        if (site == null) {
            System.out.println("ERROR: Current dir is not psc synced.");
            System.exit(-1);
        }
        PSC.initPFile(site);
        PFile pf = new PFile(site);
        if (!pf.exists()) {
            System.out.println("ERROR: Server dir is removed!?");
            System.exit(-1);
        }
        String[] ss = PSC.makeAllList(lf, pf);
        for (int i = 0; i < ss.length; ++i) {
            LFile lf2 = new LFile(lf, ss[i]);
            PFile pf2 = new PFile(pf, ss[i]);
            PSC.syncR(lf2, pf2);
        }
    }

    static String[] makeAllList(LFile lf, PFile pf) throws PFileException {
        int i;
        TreeSet<String> ts = new TreeSet<String>();
        String[] s = lf.list();
        for (i = 0; i < s.length; ++i) {
            ts.add(s[i]);
        }
        s = lf.listRemoved();
        for (i = 0; i < s.length; ++i) {
            ts.add(s[i]);
        }
        s = pf.list();
        for (i = 0; i < s.length; ++i) {
            ts.add(s[i]);
        }
        s = pf.listRemoved();
        for (i = 0; i < s.length; ++i) {
            ts.add(s[i]);
        }
        return ts.toArray(new String[0]);
    }

    static void syncR(LFile lf, PFile pf) {
        try {
            if (PSC.isSkipFile(lf.getName())) {
                System.out.println("skip: " + lf.getName());
                return;
            }
            LFile.Status lfStatus = lf.getStatus();
            boolean lfExists = lf.exists();
            boolean lfExistsInEntries = lf.existsInEntries();
            long lfModTime = lf.lastModified();
            long lfEntryTime = lf.getEntryTime();
            boolean lfIsDir = lf.isDirectory();
            boolean pfExists = pf.exists();
            boolean pfIsRemoved = pf.isRemoved();
            long pfModTime = -1L;
            if (pfExists) {
                pfModTime = pf.lastModified();
            }
            long pfRmTime = -1L;
            if (pfIsRemoved) {
                pfRmTime = pf.getRemovedTime();
            }
            boolean pfIsDir = false;
            if (pfExists) {
                pfIsDir = pf.isDirectory();
            }
            if (addF && lfExists && !lfExistsInEntries) {
                PSC.addR(lf);
                lfExistsInEntries = true;
            }
            if (removeF) {
                LFile[] lfs;
                if (lfStatus == LFile.Status.SYNCED && !lfExists) {
                    lfs = new LFile[]{lf};
                    PSC.remove2(lfs);
                } else if (lfStatus == LFile.Status.ADDED && !lfExists) {
                    lfs = new LFile[]{lf};
                    PSC.remove2(lfs);
                }
            }
            if (lfExists && lfStatus == LFile.Status.CONFLICT) {
                System.out.println("CONFLICT: " + lf.getName());
                return;
            }
            if (!lfExistsInEntries && !pfExists) {
                return;
            }
            if (lfExists && pfExists && (lfIsDir && !pfIsDir || !lfIsDir && pfIsDir)) {
                System.out.println(lf.getName() + ": type mismatch");
                return;
            }
            if (!prudenceF && lfStatus == LFile.Status.REMOVED && pfExists) {
                long timeDiff = lfEntryTime - pfModTime;
                if (timeDiff > (long)safetyMargin) {
                    if (confirmF) {
                        String msg = "server: " + pf.toString() + "\n";
                        msg = msg + " is going to be removed.";
                        if (!PSC.askConfirm(msg = msg + " Do you confirm? (y/n): ")) {
                            System.out.println("skiped:");
                            return;
                        }
                    }
                    pf.delete();
                    lf.deleteFromEntries();
                    System.out.println("remove: server " + pf.getName());
                } else if (timeDiff > 0L) {
                    System.out.println("skip remove: server " + pf.getName());
                }
                return;
            }
            if (!prudenceF && pfIsRemoved && lfExistsInEntries) {
                long timeDiff = pfRmTime - lfEntryTime;
                if (timeDiff > (long)safetyMargin) {
                    if (confirmF) {
                        String msg = "local: " + lf.toString() + "\n";
                        msg = msg + " is going to be removed.";
                        if (!PSC.askConfirm(msg = msg + " Do you confirm? (y/n): ")) {
                            System.out.println("skiped:");
                            return;
                        }
                    }
                    if (lfIsDir) {
                        lf.deleteR();
                    } else {
                        lf.delete();
                    }
                    System.out.println("remove: local " + lf.getName());
                    return;
                }
                if (timeDiff > 0L) {
                    System.out.println("skip remove: local " + lf.getName());
                    return;
                }
            }
            if (lfExists && !lfIsDir && pfExists && !pfIsDir && lfStatus == LFile.Status.FORCED) {
                if (PSC.put(pf, lf)) {
                    System.out.println("put: " + lf.getName());
                }
                return;
            }
            if (lfExists && !lfIsDir && pfExists && !pfIsDir && lfStatus == LFile.Status.ABANDON) {
                if (PSC.get(pf, lf)) {
                    System.out.println("get: " + lf.getName());
                } else {
                    System.out.println("get error?: " + lf.getName());
                }
                return;
            }
            if (!lfIsDir && !pfIsDir && lfStatus == LFile.Status.SYNCED && pfModTime - lfEntryTime > (long)safetyMargin && lfModTime - lfEntryTime > (long)safetyMargin) {
                lf.setStatus(LFile.Status.CONFLICT);
                System.out.println("CONFLICT: " + lf.getName());
                return;
            }
            if (lfExists && pfExists && !lfIsDir) {
                long tDiff = lfModTime - pfModTime;
                if (tDiff > (long)safetyMargin) {
                    if (PSC.put(pf, lf)) {
                        System.out.println("put: " + lf.getName());
                    } else {
                        System.out.println("put error?: " + lf.getName());
                    }
                    return;
                }
                if (-tDiff > (long)safetyMargin) {
                    if (PSC.get(pf, lf)) {
                        System.out.println("get: " + lf.getName());
                    } else {
                        System.out.println("get error?: " + lf.getName());
                    }
                    return;
                }
                System.out.println("already synced: " + lf.getName());
                return;
            }
            if (lfExists && !lfIsDir && !pfExists) {
                if (PSC.put(pf, lf)) {
                    System.out.println("put: " + lf.getName());
                } else {
                    System.out.println("put: error?" + lf.getName());
                }
                return;
            }
            if (lfExists && lfIsDir && !pfExists) {
                if (pf.mkdir()) {
                    lf.setStatus(LFile.Status.SYNCED);
                    lf.setEntryTime(System.currentTimeMillis());
                    System.out.println("mkdir: " + lf.getName());
                    pfExists = true;
                    pfIsDir = true;
                } else {
                    System.out.println("mkdir: error?" + lf.getName());
                    return;
                }
            }
            if (pfExists && !pfIsDir && !lfExists) {
                if (PSC.get(pf, lf)) {
                    System.out.println("get: " + lf.getName());
                } else {
                    System.out.println("get error?: " + lf.getName());
                }
                return;
            }
            if (pfExists && pfIsDir && !lfExists) {
                lf.mkdir();
                lf.setSite(pf.url);
                lf.setStatus(LFile.Status.SYNCED);
                lf.setEntryTime(System.currentTimeMillis());
                System.out.println("mkdir: " + lf.getName());
                lfExists = true;
                lfIsDir = true;
            }
            if (recursiveF && lfExists && pfExists && lfIsDir && pfIsDir) {
                String[] ss = PSC.makeAllList(lf, pf);
                for (int i = 0; i < ss.length; ++i) {
                    LFile lf2 = new LFile(lf, ss[i]);
                    PFile pf2 = new PFile(pf, ss[i]);
                    PSC.syncR(lf2, pf2);
                }
                return;
            }
            System.out.println("skip: " + lf.getName());
        }
        catch (PFileException e) {
            e.printStackTrace();
            return;
        }
    }

    static boolean askConfirm(String s) {
        try {
            System.out.print(s);
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader br = new BufferedReader(isr);
            String l = br.readLine();
            l = l.trim();
            return l.equals("y") || l.equals("Y") || l.equals("yes") || l.equals("YES");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean isSkipFile(String name) {
        boolean s = false;
        if (name.equals(".psc")) {
            s = true;
        } else if (name.equals(".svn")) {
            s = true;
        } else if (name.equals("CVS")) {
            s = true;
        } else if (name.endsWith("~")) {
            s = true;
        } else if (name.endsWith("#")) {
            s = true;
        } else if (name.startsWith("upTop")) {
            if (name.endsWith(".sh")) {
                s = true;
            }
        } else if (name.startsWith("upDir") && name.endsWith(".sh")) {
            s = true;
        }
        return s;
    }

    static boolean get(PFile pf, LFile lf) throws PFileException {
        long remoteModTime = pf.lastModified();
        if (pf.getToFile(lf)) {
            lf.setLastModified(remoteModTime);
            lf.setEntryTime(System.currentTimeMillis());
            lf.setStatus(LFile.Status.SYNCED);
            return true;
        }
        return false;
    }

    static boolean put(PFile pf, LFile lf) throws PFileException {
        long localModTime = lf.lastModified();
        if (pf.putFromFile(lf)) {
            if (!pf.setLastModified(localModTime)) {
                System.out.println("put_setLastModified error?: " + lf.getName());
            }
            lf.setEntryTime(System.currentTimeMillis());
            lf.setStatus(LFile.Status.SYNCED);
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        PSC.init();
        PSC.parseArgs(args);
    }
}

