/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LFile
extends File {
    private static final long serialVersionUID = 1L;

    public LFile(String s) {
        super(s);
    }

    public LFile(File parent, String child) {
        super(parent, child);
    }

    public long getEntryTime() {
        BufferedReader br = null;
        try {
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc/entries");
            FileReader fr = new FileReader(ff);
            br = new BufferedReader(fr);
            String s = null;
            while ((s = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, "/");
                String name = st.nextToken();
                if (!name.equals(this.getName())) continue;
                String syncTime = st.nextToken();
                br.close();
                return Long.parseLong(syncTime);
            }
            br.close();
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void setEntryTime(long l) {
        try {
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc");
            if (!ff.exists()) {
                ff.mkdir();
                this.setEntryTime2(l, new Hashtable<String, String[]>());
            } else {
                Hashtable<String, String[]> entries = new Hashtable<String, String[]>();
                File fff = new File(ff, "entries");
                if (!fff.exists()) {
                    this.setEntryTime2(l, entries);
                    return;
                }
                FileReader fr = new FileReader(fff);
                BufferedReader br = new BufferedReader(fr);
                String s = null;
                while ((s = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(s, "/");
                    String name = st.nextToken();
                    String[] syncTimeAndStatus = new String[]{st.nextToken(), st.nextToken()};
                    entries.put(name, syncTimeAndStatus);
                }
                br.close();
                this.setEntryTime2(l, entries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void setEntryTime2(long l, Hashtable<String, String[]> entries) {
        BufferedWriter bw = null;
        try {
            String[] syncTimeAndStatus = entries.get(this.getName());
            if (syncTimeAndStatus == null) {
                syncTimeAndStatus = new String[2];
                syncTimeAndStatus[1] = "none";
            }
            syncTimeAndStatus[0] = "" + l;
            entries.put(this.getName(), syncTimeAndStatus);
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc/entries");
            FileWriter fw = new FileWriter(ff);
            bw = new BufferedWriter(fw);
            Enumeration<String> e = entries.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                syncTimeAndStatus = entries.get(name);
                bw.write(name + "/" + syncTimeAndStatus[0] + "/" + syncTimeAndStatus[1] + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public Status getStatus() {
        BufferedReader br = null;
        try {
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc/entries");
            FileReader fr = new FileReader(ff);
            br = new BufferedReader(fr);
            String s = null;
            while ((s = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, "/");
                String name = st.nextToken();
                if (!name.equals(this.getName())) continue;
                st.nextToken();
                String status = st.nextToken();
                br.close();
                try {
                    return Status.valueOf(status);
                }
                catch (IllegalArgumentException e) {
                    return Status.NONE;
                }
            }
            br.close();
            return Status.NONE;
        }
        catch (Exception e) {
            return Status.NONE;
        }
    }

    public void setStatus(Status status) {
        BufferedReader br = null;
        try {
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc");
            if (!ff.exists()) {
                ff.mkdir();
                this.setStatus2(status, new Hashtable<String, String[]>());
            } else {
                Hashtable<String, String[]> entries = new Hashtable<String, String[]>();
                File fff = new File(ff, "entries");
                if (!fff.exists()) {
                    this.setStatus2(status, entries);
                    return;
                }
                FileReader fr = new FileReader(fff);
                br = new BufferedReader(fr);
                String s = null;
                while ((s = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(s, "/");
                    String name = st.nextToken();
                    String[] syncTimeAndStatus = new String[]{st.nextToken(), st.nextToken()};
                    entries.put(name, syncTimeAndStatus);
                }
                br.close();
                this.setStatus2(status, entries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void setStatus2(Status status, Hashtable<String, String[]> entries) {
        BufferedWriter bw = null;
        try {
            String[] syncTimeAndStatus = entries.get(this.getName());
            if (syncTimeAndStatus == null) {
                syncTimeAndStatus = new String[]{"NONE", status.toString()};
            }
            entries.put(this.getName(), syncTimeAndStatus);
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc/entries");
            FileWriter fw = new FileWriter(ff);
            bw = new BufferedWriter(fw);
            Enumeration<String> e = entries.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                syncTimeAndStatus = entries.get(name);
                bw.write(name + "/" + syncTimeAndStatus[0] + "/" + syncTimeAndStatus[1] + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public LFile[] listFiles() {
        File[] files = super.listFiles();
        Vector<LFile> v = new Vector<LFile>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".psc")) continue;
            v.add(new LFile(files[i].getAbsolutePath()));
        }
        LFile[] ret = v.toArray(new LFile[0]);
        return ret;
    }

    public LFile[] listFilesInEntries() {
        BufferedReader br = null;
        try {
            File f = new File(this, ".psc/entries");
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            Vector<String> v = new Vector<String>();
            String s = null;
            while ((s = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, "/");
                String name = st.nextToken();
                v.add(name);
            }
            br.close();
            LFile[] ret = new LFile[v.size()];
            int i = 0;
            for (String name : v) {
                ret[i++] = new LFile(this, name);
            }
            return ret;
        }
        catch (Exception e) {
            return new LFile[0];
        }
    }

    public String[] listRemoved() {
        BufferedReader br = null;
        try {
            File f = new File(this, ".psc/entries");
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            Vector<String> v = new Vector<String>();
            String s = null;
            while ((s = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, "/");
                String name = st.nextToken();
                st.nextToken();
                String status = st.nextToken();
                if (!status.equals("removed")) continue;
                v.add(name);
            }
            br.close();
            return v.toArray(new String[0]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public String getSite() {
        BufferedReader br = null;
        try {
            File f = new File(this, ".psc/site");
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            String s = br.readLine();
            br.close();
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setSite(String s) {
        while (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        BufferedWriter bw = null;
        try {
            File f = new File(this, ".psc");
            if (!f.exists()) {
                f.mkdir();
            }
            File ff = new File(f, "site");
            FileWriter fw = new FileWriter(ff);
            bw = new BufferedWriter(fw);
            bw.write(s + "\n");
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean existsInEntries() {
        BufferedReader br = null;
        try {
            LFile f = this.getParentFile();
            LFile ff = new LFile(f, ".psc/entries");
            FileReader fr = new FileReader(ff);
            br = new BufferedReader(fr);
            String s = null;
            while ((s = br.readLine()) != null) {
                s = s.trim();
                if (!(s = s.substring(0, s.indexOf(47))).equals(this.getName())) continue;
                return true;
            }
            br.close();
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public LFile getParentFile() {
        String p = this.getParent();
        return new LFile(p);
    }

    public void deleteR() {
        LFile[] lfs = this.listFiles();
        for (int i = 0; i < lfs.length; ++i) {
            if (lfs[i].isDirectory()) {
                lfs[i].deleteR();
                continue;
            }
            lfs[i].delete();
        }
    }

    public void deleteFromEntries() {
        BufferedReader br = null;
        try {
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc");
            if (!ff.exists()) {
                ff.mkdir();
                this.deleteFromEntries2(new Hashtable<String, String[]>());
            } else {
                Hashtable<String, String[]> entries = new Hashtable<String, String[]>();
                File fff = new File(ff, "entries");
                if (!fff.exists()) {
                    this.deleteFromEntries2(entries);
                    return;
                }
                FileReader fr = new FileReader(fff);
                br = new BufferedReader(fr);
                String s = null;
                while ((s = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(s, "/");
                    String name = st.nextToken();
                    String[] syncTimeAndStatus = new String[]{st.nextToken(), st.nextToken()};
                    entries.put(name, syncTimeAndStatus);
                }
                br.close();
                this.deleteFromEntries2(entries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    void deleteFromEntries2(Hashtable<String, String[]> entries) {
        BufferedWriter bw = null;
        try {
            entries.remove(this.getName());
            String[] syncTimeAndStatus = new String[2];
            LFile f = this.getParentFile();
            File ff = new File(f, ".psc/entries");
            FileWriter fw = new FileWriter(ff);
            bw = new BufferedWriter(fw);
            Enumeration<String> e = entries.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                syncTimeAndStatus = entries.get(name);
                bw.write(name + "/" + syncTimeAndStatus[0] + "/" + syncTimeAndStatus[1] + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public boolean delete() {
        this.deleteFromEntries();
        return super.delete();
    }

    public static enum Status {
        SYNCED,
        ADDED,
        REMOVED,
        CONFLICT,
        ABANDON,
        FORCED,
        NONE;

    }
}

