/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.bin.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import jp.sfjp.mikutoga.bin.parser.BinParser;
import jp.sfjp.mikutoga.bin.parser.MmdEofException;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.TextDecoder;

public class CommonParser
implements BinParser {
    private static final String ERRMSG_ILLENC = "illegal character encoding";
    private static final String ERRMSG_UNMAP = "unmapped character";
    private static final int BYTES_SHORT = 2;
    private static final int BYTES_INT = 4;
    private static final int BYTES_FLOAT = 4;
    private static final int BYTES_PRIM = 4;
    private static final int MASK_8BIT = 255;
    private static final int MASK_16BIT = 65535;
    private final PushbackInputStream is;
    private final byte[] readBuffer;
    private final ByteBuffer leBuf;
    private long position = 0L;
    private ByteBuffer btextBuf;

    public CommonParser(InputStream source) {
        this.is = new PushbackInputStream(source, 1);
        this.readBuffer = new byte[4];
        this.leBuf = ByteBuffer.wrap(this.readBuffer);
        this.leBuf.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public long getPosition() {
        long result = this.position;
        return result;
    }

    @Override
    public boolean hasMore() throws IOException {
        int bVal;
        try {
            bVal = this.is.read();
        }
        catch (EOFException e) {
            return false;
        }
        if (bVal < 0) {
            return false;
        }
        this.is.unread(bVal);
        return true;
    }

    @Override
    public void skip(long skipLength) throws IOException, MmdEofException {
        long remain = skipLength;
        while (remain > 0L) {
            long txSize = this.is.skip(remain);
            if (txSize <= 0L) {
                throw new MmdEofException(this.position);
            }
            remain -= txSize;
            this.position += txSize;
        }
    }

    @Override
    public void parseByteArray(byte[] dst, int off, int length) throws NullPointerException, IndexOutOfBoundsException, IOException, MmdEofException {
        int remain = length;
        int offset = off;
        while (remain > 0) {
            int txSize = this.is.read(dst, offset, remain);
            if (txSize <= 0) {
                throw new MmdEofException(this.position);
            }
            remain -= txSize;
            offset += txSize;
            this.position += (long)txSize;
        }
    }

    @Override
    public void parseByteArray(byte[] dst) throws NullPointerException, IOException, MmdEofException {
        this.parseByteArray(dst, 0, dst.length);
    }

    private void fillBuffer(int fillSize) throws IOException, MmdEofException {
        this.parseByteArray(this.readBuffer, 0, fillSize);
    }

    @Override
    public byte parseByte() throws IOException, MmdEofException {
        int bData = this.is.read();
        if (bData < 0) {
            throw new MmdEofException(this.position);
        }
        byte result = (byte)bData;
        ++this.position;
        return result;
    }

    @Override
    public int parseUByteAsInt() throws IOException, MmdEofException {
        return this.parseByte() & 0xFF;
    }

    @Override
    public boolean parseBoolean() throws IOException, MmdEofException {
        byte result = this.parseByte();
        return result != 0;
    }

    @Override
    public short parseLeShort() throws IOException, MmdEofException {
        this.fillBuffer(2);
        short result = this.leBuf.getShort(0);
        return result;
    }

    @Override
    public int parseLeUShortAsInt() throws IOException, MmdEofException {
        return this.parseLeShort() & 0xFFFF;
    }

    @Override
    public int parseLeInt() throws IOException, MmdEofException {
        this.fillBuffer(4);
        int result = this.leBuf.getInt(0);
        return result;
    }

    @Override
    public float parseLeFloat() throws IOException, MmdEofException {
        this.fillBuffer(4);
        float result = this.leBuf.getFloat(0);
        return result;
    }

    @Override
    public String parseString(TextDecoder decoder, int byteLen) throws IOException, MmdEofException, MmdFormatException {
        String result;
        if (this.btextBuf == null || this.btextBuf.capacity() < byteLen) {
            this.btextBuf = ByteBuffer.allocate(byteLen);
        }
        byte[] buf = this.btextBuf.array();
        this.btextBuf.clear();
        this.parseByteArray(buf, 0, byteLen);
        this.btextBuf.limit(byteLen);
        try {
            result = decoder.decode(this.btextBuf);
        }
        catch (UnmappableCharacterException e) {
            String errmsg = ERRMSG_UNMAP;
            long errpos = this.getPosition() - (long)byteLen + (long)e.getInputLength();
            MmdFormatException ex = new MmdFormatException(errmsg, errpos);
            ex.initCause(e);
            throw ex;
        }
        catch (MalformedInputException e) {
            String errmsg = ERRMSG_ILLENC;
            long errpos = this.getPosition() - (long)byteLen + (long)e.getInputLength();
            MmdFormatException ex = new MmdFormatException(errmsg, errpos);
            ex.initCause(e);
            throw ex;
        }
        catch (CharacterCodingException e) {
            String errmsg = ERRMSG_ILLENC;
            long errpos = this.getPosition();
            MmdFormatException ex = new MmdFormatException(errmsg, errpos);
            ex.initCause(e);
            throw ex;
        }
        return result;
    }
}

