/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;

public class ShadowPose
extends Pose {
    public float distance;
    public byte mode;

    public ShadowPose() {
        this.nameOfBone = "\u30bb\u30eb\u30d5\u5f71";
        this.distance = 50.0f;
        this.mode = 1;
    }

    public ShadowPose(ShadowPose p) {
        super(p);
        this.distance = p.distance;
        this.mode = p.mode;
    }

    public static ShadowPose fromCSV(String line) {
        String[] column = CsvSpliter.split(line);
        if (column.length < 3) {
            return null;
        }
        ShadowPose p = new ShadowPose();
        p.frame = Integer.parseInt(column[0]);
        p.mode = Byte.parseByte(column[1]);
        p.distance = Float.parseFloat(column[2]);
        return p;
    }

    @Override
    public String toCSV() {
        return this.frame + "," + this.mode + "," + this.distance + "\n";
    }

    @Override
    protected byte[] toVMD() {
        ByteBuffer ret = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(this.frame);
        ret.put(this.mode);
        ret.putFloat(this.distance);
        return ret.array();
    }

    @Override
    public Pose clone() {
        return new ShadowPose(this);
    }
}

