/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdBoneHandler;

/**
 * PMD データを読み出すのに使用するハンドラ.
 * @author nazo
 */
public class PmdFileHander implements PmdBoneHandler,PmdBasicHandler{
    private Model model;
    private Bone bone=null;
    private ArrayList<String> al=new ArrayList<String>();
    private TreeMap<Integer,Integer> tm=new TreeMap<Integer, Integer>();
    
    public PmdFileHander(Model model){
        super();
        this.model=model;
    }
    @Override
    public void pmdParseStart() throws MmdFormatException {
    }

    @Override
    public void pmdHeaderInfo(byte[] header) throws MmdFormatException {
        if(header[0]!='P'||header[1]!='m'||header[2]!='d'){
            throw new MmdFormatException("Not PMD file.");
        }
    }

    @Override
    public void pmdModelInfo(String modelName, String description) throws MmdFormatException {
        model.setName(modelName);
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
    }

    @Override
    public void pmdBoneInfo(String boneName, byte boneKind) throws MmdFormatException {
        bone=new Bone(model);
        bone.name=boneName;
        al.add(boneName);
        switch(boneKind){
            case 8:
                bone.limitRot=new Vector3D();
                break;
        }
    }

    @Override
    public void pmdBoneLink(int parentId, int tailId, int ikId) throws MmdFormatException {
        if(parentId==0xffff){
            bone.parent=null;
        }else {
            bone.parent=al.get(parentId);
            model.get(bone.parent).addChild(bone);
        }
        tm.put(al.size()-1, tailId);
    }

    @Override
    public void pmdBonePosition(float xPos, float yPos, float zPos) throws MmdFormatException {
        bone.gv=new Vector3D(xPos,yPos,zPos);
        bone.mr=new Matrix();
        bone.ini_mr=new Matrix();
    }

    @Override
    public void pmdIKInfo(int boneId, int targetId, int depth, float weight) throws MmdFormatException {
    }

    @Override
    public void pmdIKChainInfo(int childId) throws MmdFormatException {
    }

    @Override
    public void pmdBoneGroupInfo(String groupName) throws MmdFormatException {
    }

    @Override
    public void pmdGroupedBoneInfo(int boneId, int groupId) throws MmdFormatException {
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        if(bone!=null){
            model.put(bone.name, bone);
        }
        bone=null;
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
    }

    @Override
    public void pmdParseEnd(boolean hasMoreData) throws MmdFormatException {
    }
    
}
