/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

class I18nAlias {
    public static final Comparator<I18nAlias> ORDER_COMPARATOR = new OrderComparator();
    private int orderNo;
    private final List<String> primaryNameList;
    private final List<String> globalNameList;
    private final List<String> umodPrimaryNameList;
    private final List<String> umodGlobalNameList;

    protected I18nAlias(int primaryNum, int globalNum) {
        this.primaryNameList = primaryNum <= 0 ? new LinkedList<String>() : new ArrayList<String>(primaryNum);
        this.globalNameList = globalNum <= 0 ? new LinkedList<String>() : new ArrayList<String>(globalNum);
        this.umodPrimaryNameList = Collections.unmodifiableList(this.primaryNameList);
        this.umodGlobalNameList = Collections.unmodifiableList(this.globalNameList);
    }

    protected I18nAlias() {
        this(0, 0);
    }

    protected static Element loadXml(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        Element top = doc.getDocumentElement();
        return top;
    }

    protected int getOrderNo() {
        return this.orderNo;
    }

    protected void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    public String getTopPrimaryName() {
        String result = this.primaryNameList.get(0);
        return result;
    }

    public String getTopGlobalName() {
        if (this.globalNameList.isEmpty()) {
            return null;
        }
        String result = this.globalNameList.get(0);
        return result;
    }

    public List<String> getPrimaryNameList() {
        return this.umodPrimaryNameList;
    }

    protected void addPrimaryName(String primaryName) {
        this.primaryNameList.add(primaryName);
    }

    public List<String> getGlobalNameList() {
        return this.umodGlobalNameList;
    }

    protected void addGlobalName(String globalName) {
        this.globalNameList.add(globalName);
    }

    private static class OrderComparator
    implements Comparator<I18nAlias> {
        OrderComparator() {
        }

        @Override
        public int compare(I18nAlias o1, I18nAlias o2) {
            int result = o1.getOrderNo() - o2.getOrderNo();
            return result;
        }
    }
}

