/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.typical;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.sfjp.mikutoga.typical.AliasMap;
import jp.sfjp.mikutoga.typical.I18nAlias;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TypicalBone
extends I18nAlias {
    private static final Class<?> THISCLASS;
    private static final String BONE_XML = "resources/typicalBone.xml";
    private static final String ELEM_BONE = "bone";
    private static final String ELEM_ROOT = "root";
    private static final String ELEM_PRIMARY = "primary";
    private static final String ELEM_GLOBAL = "global";
    private static final String ATTR_NAME = "name";
    private static final List<TypicalBone> BONE_LIST;
    private static final AliasMap<TypicalBone> BONE_ALIAS_MAP;
    private static final List<TypicalBone> BONE_UNMODLIST;
    private boolean isRoot;

    private TypicalBone(int primaryNum, int globalNum) {
        super(primaryNum, globalNum);
        assert (this.getClass() == THISCLASS);
    }

    private static void parse(Element top) {
        NodeList boneList = top.getElementsByTagName(ELEM_BONE);
        int boneNo = boneList.getLength();
        for (int idx = 0; idx < boneNo; ++idx) {
            Element boneElem = (Element)boneList.item(idx);
            TypicalBone typBone = TypicalBone.parseBone(boneElem);
            BONE_LIST.add(typBone);
            BONE_ALIAS_MAP.addAlias(typBone);
        }
    }

    private static TypicalBone parseBone(Element boneElem) {
        String name;
        int idx;
        NodeList primaryNodes = boneElem.getElementsByTagName(ELEM_PRIMARY);
        NodeList globalNodes = boneElem.getElementsByTagName(ELEM_GLOBAL);
        int primaryNo = primaryNodes.getLength();
        int globalNo = globalNodes.getLength();
        assert (primaryNo > 0);
        TypicalBone bone = new TypicalBone(primaryNo, globalNo);
        for (idx = 0; idx < primaryNo; ++idx) {
            Element primaryElem = (Element)primaryNodes.item(idx);
            name = primaryElem.getAttribute(ATTR_NAME);
            bone.addPrimaryName(name);
        }
        for (idx = 0; idx < globalNo; ++idx) {
            Element globalElem = (Element)globalNodes.item(idx);
            name = globalElem.getAttribute(ATTR_NAME);
            bone.addGlobalName(name);
        }
        NodeList rootNodes = boneElem.getElementsByTagName(ELEM_ROOT);
        bone.isRoot = rootNodes.getLength() > 0;
        return bone;
    }

    private static void numbering() {
        int order = 0;
        for (TypicalBone bone : BONE_LIST) {
            bone.setOrderNo(order++);
        }
    }

    public static List<TypicalBone> getTypicalBoneList() {
        return BONE_UNMODLIST;
    }

    public static TypicalBone findWithPrimary(String primaryName) {
        TypicalBone result = BONE_ALIAS_MAP.getAliasByPrimary(primaryName);
        return result;
    }

    public static TypicalBone findWithGlobal(String globalName) {
        TypicalBone result = BONE_ALIAS_MAP.getAliasByGlobal(globalName);
        return result;
    }

    public static String primary2global(String primaryName) {
        String globalName = BONE_ALIAS_MAP.primary2global(primaryName);
        return globalName;
    }

    public static String global2primary(String globalName) {
        String primaryName = BONE_ALIAS_MAP.global2primary(globalName);
        return primaryName;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    static {
        Element top;
        THISCLASS = TypicalBone.class;
        BONE_LIST = new LinkedList<TypicalBone>();
        BONE_ALIAS_MAP = new AliasMap();
        BONE_UNMODLIST = Collections.unmodifiableList(BONE_LIST);
        InputStream is = THISCLASS.getResourceAsStream(BONE_XML);
        try {
            top = I18nAlias.loadXml(is);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        TypicalBone.parse(top);
        TypicalBone.numbering();
    }
}

