/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class BoneTableModel
extends AbstractTableModel {
    private static final String[] colName = new String[]{"name", "limited", "noX", "noY", "noZ"};
    ArrayList<Row> entries = new ArrayList();
    protected Model model;

    void setMMDModel(Model m) {
        this.removeAll();
        this.model = m;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return colName.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex > 0 && columnIndex < 5) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex >= 2 && !this.entries.get((int)rowIndex).l;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (columnIndex < 2) {
            return;
        }
        Row a = this.entries.get(rowIndex);
        Boolean b = (Boolean)aValue;
        switch (columnIndex) {
            case 2: {
                a.lx = b;
                return;
            }
            case 3: {
                a.ly = b;
                return;
            }
            case 4: {
                a.lz = b;
                return;
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Row a = this.entries.get(rowIndex);
        if (a == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return a.name;
            }
            case 1: {
                return a.l;
            }
            case 2: {
                return a.lx;
            }
            case 3: {
                return a.ly;
            }
            case 4: {
                return a.lz;
            }
        }
        return null;
    }

    public void add(String s, int order) {
        Row n = new Row(s, order);
        int i = 0;
        for (Row o : this.entries) {
            if (o.order >= order) {
                if (o.name.compareTo(s) == 0) {
                    return;
                }
                this.entries.add(i, n);
                break;
            }
            ++i;
        }
        if (i == this.entries.size()) {
            this.entries.add(n);
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return colName[col];
    }

    public void removeRow(int row) {
        if (0 <= row && row < this.entries.size()) {
            this.entries.remove(row);
        }
    }

    public void removeAll() {
        this.entries.clear();
        this.fireTableDataChanged();
    }

    class Row {
        String name;
        int order;
        boolean lx;
        boolean ly;
        boolean lz;
        boolean l;

        Row(String s, int i) {
            this.name = s;
            this.order = i;
            Bone bone = BoneTableModel.this.model.get(this.name);
            this.l = bone.getLimitRot() != null;
            this.lz = false;
            this.ly = false;
            this.lx = false;
        }
    }
}

