﻿using System;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// MMD用のボーンデータ
    /// </summary>
    public class MMDBoneData
    {
        /// <summary>
        /// 対象となるボーンの名前
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// ボーンの種類
        /// </summary>
        public MMDBoneType BoneType { get; set; }
        /// <summary>
        /// IKボーンの接続先(影響IKボーン)
        /// </summary>
        public UInt16 IKParentBoneIndex { get; set; }

        /// <summary>
        /// ボーンのバインドポーズ行列
        /// </summary>
        public QuatTransform BindPose { get; set; }
        /// <summary>
        /// ボーンのバインドポーズ逆行列
        /// </summary>
        public QuatTransform InverseBindPose { get; set; }
        /// <summary>
        /// ボーンの親のボーンのインデックス情報
        /// </summary>
        /// <remarks>親が無い場合は-1</remarks>
        public int SkeletonHierarchy { get; set; }
        /// <summary>
        /// ボーンのIK情報
        /// </summary>
        public MMDIKData IK { get; set; }
    }
}
