﻿using BulletX.BulletCollision.CollisionShapes;
using BulletX.LinerMath;

namespace BulletX.BulletCollision.NarrowPhaseCollision
{
    struct MinkowskiDiff
    {
        public ConvexShape m_shapes0;

        public ConvexShape m_shapes1;

        
        public btMatrix3x3 m_toshape1;
        public btTransform m_toshape0;

        public void					EnableMargin(bool enable)
		{
            if(enable)
            {
                m_shapes0.Ls = m_shapes0.localGetSupportVertexNonVirtualDelegate;
                m_shapes1.Ls = m_shapes1.localGetSupportVertexNonVirtualDelegate;
            }
            else{
                m_shapes0.Ls = m_shapes0.localGetSupportVertexWithoutMarginNonVirtualDelegate;
                m_shapes1.Ls = m_shapes1.localGetSupportVertexWithoutMarginNonVirtualDelegate;
            }
		}	

        btVector3 Support0(btVector3 d)
        {
            return ((m_shapes0).Ls(d));
        }
        btVector3 Support1(btVector3 d)
        {
            return (m_toshape0 * (m_shapes1).Ls(m_toshape1 * d));
        }
        public btVector3 Support(btVector3 d)
        {
            return (Support0(d) - Support1(-d));
        }
        public btVector3 Support(btVector3 d, uint index)
        {
            if (index != 0)
                return (Support1(d));
            else
                return (Support0(d));
        }
    }
}
