#region Using Xe[gg

using System;
using System.Globalization;
using System.Text;

#endregion

namespace MikuMikuDance.XNA.Debug.Utils
{
    /// <summary>
    /// StringBuilderg\bhpIvV
    /// </summary>
    [Flags]
    public enum AppendNumberOptions
    {
        /// <summary>
        /// ʏtH[}bg
        /// </summary>
        None = 0,

        /// <summary>
        /// ̒l̎ɂ"+"
        /// </summary>
        PositiveSign = 1,

        /// <summary>
        /// R","\
        /// </summary>
        NumberGroup = 2,
    }

    /// <summary>
    /// StringBuilderp̊g\bh錾pÓINX
    /// </summary>
    /// <remarks>
    /// XNA GS 3.0SpriteFont.DrawStringɂStringBuilder
    /// wł悤ɂȂAsKvȃmۂȂȂB
    /// 
    /// A\ɂ͂Q̖肪B
    /// ЂƂStringBuilder.AppendFormat\bhg
    /// {NVOĂ܂ƁB
    /// ЂƂ́AStringBuilder.AppendŐlfloatlw肷
    /// ŃmۂĂ܂ƁB
    /// 
    /// mۂ{NVOɐ\ɍŒKvȃtH[}bg@\
    /// ̃NX͒񋟂B
    /// 
    /// StringBuilder̊g\bhƂĐ錾Ă̂ňȉ̂悤ɂĎgp
    /// 
    /// stringBuilder.AppendNumber(12345);
    /// 
    /// </remarks>
    public static class StringBuilderExtensions
    {
        #region tB[h

        /// <summary>
        /// NumberFormatNXNumberGroupSizes̃LbV
        /// </summary>
        static int[] numberGroupSizes =
            CultureInfo.CurrentCulture.NumberFormat.NumberGroupSizes;

        /// <summary>
        /// ϊp̃obt@
        /// </summary>
        static char[] numberString = new char[32];

        #endregion

        /// <summary>
        /// 𕶎ɕϊStringBuilderɒǉ
        /// </summary>
        public static void AppendNumber( this StringBuilder builder, int number )
        {
            AppendNumbernternal( builder, number, 0, AppendNumberOptions.None );
        }

        /// <summary>
        /// 𕶎ɕϊStringBuilderɒǉ
        /// </summary>
        /// <param name="number">l</param>
        /// <param name="options">tH[}bgwIvV</param>
        /// <param name="builder">StringBulderNX</param>
        public static void AppendNumber( this StringBuilder builder, int number,
                                                            AppendNumberOptions options )
        {
            AppendNumbernternal( builder, number, 0, options );
        }

        /// <summary>
        /// floatl𕶎ɕϊStringBuilderɒǉ
        /// </summary>
        /// <param name="number">ϊ鐔</param>
        /// <remarks>_ȉ񌅂܂ŕ\</remarks>
        /// <param name="builder">StringBulderNX</param>
        public static void AppendNumber(this StringBuilder builder, float number)
        {
            AppendNumber( builder, number, 2, AppendNumberOptions.None );
        }

        /// <summary>
        /// floatl𕶎ɕϊStringBuilderɒǉ
        /// </summary>
        /// <param name="number">ϊ鐔</param>
        /// <param name="options">tH[}bgwIvV</param>
        /// <remarks>_ȉ񌅂܂ŕ\</remarks>
        /// <param name="builder">StringBulderNX</param>
        public static void AppendNumber(this StringBuilder builder, float number,
                                                            AppendNumberOptions options )
        {
            AppendNumber( builder, number, 2, options );
        }

        /// <summary>
        /// floatl𕶎ɕϊStringBuilderɒǉ
        /// </summary>
        /// <param name="number">ϊ鐔</param>
        /// <param name="decimalCount">\鏬_ȉ̌</param>
        /// <param name="options">tH[}bgwIvV</param>
        /// <param name="builder">StringBulderNX</param>
        public static void AppendNumber(this StringBuilder builder, float number,
                                        int decimalCount, AppendNumberOptions options )
        {
            // NaN, Infinity̐l̓P[X
            if ( float.IsNaN( number ) )
            {
                builder.Append( "NaN" );
            }
            else if ( float.IsNegativeInfinity( number ) )
            {
                builder.Append( "-Infinity" );
            }
            else if ( float.IsPositiveInfinity( number ) )
            {
                builder.Append( "+Infinity" );
            }
            else
            {
                int intNumber =
                        (int)( number * (float)Math.Pow( 10, decimalCount ) + 0.5f );

                AppendNumbernternal( builder, intNumber, decimalCount, options );
            }
        }


        static void AppendNumbernternal( StringBuilder builder, int number,
                                        int decimalCount, AppendNumberOptions options )
        {
            // ϊɕKvȕϐ̏
            NumberFormatInfo nfi = CultureInfo.CurrentCulture.NumberFormat;

            int idx = numberString.Length;
            int decimalPos = idx - decimalCount;

            if ( decimalPos == idx )
                decimalPos = idx + 1;

            int numberGroupIdx = 0;
            int numberGroupCount = numberGroupSizes[numberGroupIdx] + decimalCount;

            bool showNumberGroup = ( options & AppendNumberOptions.NumberGroup ) != 0;
            bool showPositiveSign = ( options & AppendNumberOptions.PositiveSign ) != 0;

            bool isNegative = number < 0;
            number = Math.Abs( number );

            // ŏe𕶎ɕϊ
            do
            {
                // _̋؂蕶({ł".")̒ǉ
                if ( idx == decimalPos )
                {
                    numberString[--idx] = nfi.NumberDecimalSeparator[0];
                }

                // O[v؂蕶({ł",")̒ǉ
                if ( --numberGroupCount < 0 && showNumberGroup )
                {
                    numberString[--idx] = nfi.NumberGroupSeparator[0];

                    if ( numberGroupIdx < numberGroupSizes.Length - 1 )
                        numberGroupIdx++;

                    numberGroupCount = numberGroupSizes[numberGroupIdx++];
                }

                // ݂̌𕶎ɕϊăobt@ɒǉ
                numberString[--idx] = (char)( '0' + ( number % 10 ) );
                number /= 10;

            } while ( number > 0 || decimalPos <= idx );


            // KvȂǉ
            if ( isNegative )
            {
                numberString[--idx] = nfi.NegativeSign[0];
            }
            else if ( showPositiveSign )
            {
                numberString[--idx] = nfi.PositiveSign[0];
            }

            // ϊʂStringBuilderɒǉ
            builder.Append( numberString, idx, numberString.Length - idx );
        }

    }
}