using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using System.Threading;

namespace MikuMikuDance.XNA.MultiThread
{
    /// <summary>
    /// Q[XbhNX
    /// </summary>
    public abstract class GameThread<BufferType> : IGameThread
        where BufferType:class, new()
    {
        private volatile int currentBuf;
        private volatile BufferType[] buffers;
        volatile bool StartEndCheck = false;
#if XBOX
        /// <summary>
        /// n[hEFAXbhԍ
        /// </summary>
        protected readonly int HWThreadNum;
#endif
        private volatile AutoResetEvent FrameStart;
        private volatile AutoResetEvent FrameEnd;
        /// <summary>
        /// Xbh}l[W
        /// </summary>
        protected ThreadManager Manager { get; private set; }
        /// <summary>
        /// Xbh
        /// </summary>
        public Thread ThreadObj { get; private set; }
        /// <summary>
        /// GameIuWFNg
        /// </summary>
        protected Game Game { get; private set; }

        internal volatile GameTime gameTime;
        /// <summary>
        /// XbhŏłȂobt@IuWFNg
        /// </summary>
        public BufferType FreeBuffer { get { return buffers[(currentBuf + 1) % 2]; } }
        /// <summary>
        /// Xbhŏ݉\ȃobt@IuWFNg
        /// </summary>
        protected BufferType WritableBuffer { get { return buffers[currentBuf]; } }
#if XBOX
        /// <summary>
        /// Q[XbhRXgN^
        /// </summary>
        /// <param name="HWThreadNum">n[hEFAXbhԍ</param>
        /// <param name="game">GameNX</param>
        /// <param name="manager">Xbh}l[W</param>
        public GameThread(int HWThreadNum, Game game, ThreadManager manager)
#else
        /// <summary>
        /// Q[XbhRXgN^
        /// </summary>
        /// <param name="game">GameNX</param>
        /// <param name="manager">Xbh}l[W</param>
        public GameThread(Game game, ThreadManager manager)
#endif
        {
            Game = game;
            Manager = manager;
            if (manager != null)
                manager.AddThread(this);
            FrameStart = new AutoResetEvent(false);
            FrameEnd = new AutoResetEvent(false);
            buffers = new BufferType[2] { new BufferType(), new BufferType() };
#if XBOX
            this.HWThreadNum = HWThreadNum;
#endif
            Reset();
            ThreadObj = new Thread(new ThreadStart(work));
            ThreadObj.Start();
        }
        /// <summary>
        /// Zbg
        /// </summary>
        protected virtual void Reset()
        {
            currentBuf = 0;
            FrameStart.Reset();
            FrameEnd.Reset();
        }
        /// <summary>
        /// Xbh̔j
        /// </summary>
        public virtual void Dispose()
        {
            if (ThreadObj != null)
            {
                ThreadObj.Abort();
                ThreadObj = null;
                FrameStart.Close();
                FrameEnd.Close();
            }
        }

        private void work()
        {
#if XBOX
            Thread.CurrentThread.SetProcessorAffinity(HWThreadNum);
#endif
            try
            {
                while (true)
                {
                    FrameStart.WaitOne();//
                    Thread.MemoryBarrier();
                    if (Manager != null)
                        gameTime = Manager.gameTime;
                    this.Update(gameTime);
                    Thread.MemoryBarrier();
                    FrameEnd.Set();//Iɓ`
                }
            }
            catch (ThreadAbortException)
            { }
        }
        /// <summary>
        /// Q[Xbh̍XV
        /// </summary>
        /// <param name="gameTime">GameTimeIuWFNg</param>
        public abstract void Update(GameTime gameTime);
        
        
        internal virtual void SwapBuffer()
        {
            currentBuf = (currentBuf + 1) % 2;
        }

        /// <summary>
        /// XbhɃt[Jn`
        /// </summary>
        public virtual void StartFrame()
        {
            SwapBuffer();
            FrameStart.Set();//XbhɊJn`
            StartEndCheck = true;
        }
        /// <summary>
        /// Xbht[I܂ő҂
        /// </summary>
        public virtual void Synchronize()
        {
            if (!StartEndCheck)
                return;
            FrameEnd.WaitOne();//Xbh1t[̏܂ő҂
            StartEndCheck = false;
        }

        
    }
}