#region Using Xe[gg

using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;
using MikuMikuDance.XNA.Debug.Utils;

#endregion

namespace MikuMikuDance.XNA.Debug
{
    /// <summary>
    /// L[{[h͊֘Ã[eBeBNX(ɓ Y(HN:Ђ˂))
    /// </summary>
    public abstract class KeyboardUtils
    {
        #region tB[h

        /// <summary>
        /// ʏ̕ƃVtgL[ꂽ̕ێ镶yANX
        /// </summary>
        class CharPair
        {
            public CharPair( char normalChar, Nullable<char> shiftChar )
            {
                this.NormalChar = normalChar;
                this.ShiftChar = shiftChar;
            }

            public char NormalChar;
            public Nullable<char> ShiftChar;
        }

        // L[:Keys, l:CharPair
        private Dictionary<Keys, CharPair> keyMap =
                                                    new Dictionary<Keys, CharPair>();

        #endregion

        /// <summary>
        /// L[񂩂當擾
        /// </summary>
        /// <param name="key">ꂽL[</param>
        /// <param name="shitKeyPressed">VtgL[Ă?</param>
        /// <param name="character">L[͂ϊꂽ</param>
        /// <returns>擾ꍇtrueԂ</returns>
        public bool KeyToString( Keys key, bool shitKeyPressed,
                                                                    out char character )
        {
            bool result = false;
            character = ' ';
            CharPair charPair;

            if ( ( Keys.A <= key && key <= Keys.Z ) || key == Keys.Space )
            {
                // A`ZAXy[XL[͂̂܂ܕR[hƂĎgp
                character = ( shitKeyPressed ) ? (char)key : Char.ToLower( (char)key );
                result = true;
            }
            else if ( keyMap.TryGetValue( key, out charPair ) )
            {
                // ȊȌꍇKeyMap̏ɕϊ
                if ( !shitKeyPressed )
                {
                    character = charPair.NormalChar;
                    result = true;
                }
                else if ( charPair.ShiftChar.HasValue )
                {
                    character = charPair.ShiftChar.Value;
                    result = true;
                }
            }

            return result;
        }

        #region 
        /// <summary>
        /// L[{[hutil̏
        /// </summary>
        public KeyboardUtils()
        {
            InitializeKeyMap();
        }

        /// <summary>
        /// pȊÕL[̕}bv̏
        /// </summary>
        /// <remarks>pŃCAEgݒ</remarks>
        protected abstract void InitializeKeyMap();
        

        /// <summary>
        ///@L[{[h̃L[ƕ}bv̒ǉ
        /// </summary>
        /// <param name="key">L[{[h̃L[</param>
        /// <param name="charPair">
        /// AQ̏ꍇ̓VtgL[AL菇ԂɋLq</param>
        protected void AddKeyMap( Keys key, string charPair )
        {
            char char1 = charPair[0];
            Nullable<char> char2 = null;
            if ( charPair.Length > 1 )
                char2 = charPair[1];

            keyMap.Add( key, new CharPair( char1, char2 ) );
        }

        #endregion

        /// <summary>
        /// t@Ng[\bh
        /// </summary>
        /// <param name="type">L[{[h^Cv</param>
        /// <returns>KeyboardUtils</returns>
        public static KeyboardUtils Create(KeyboardType type)
        {
            switch (type)
            {
                case KeyboardType.Japanese:
                    return new JapaneseKeyboardUtils();
                case KeyboardType.English:
                    return new EnglishKeyboardUtil();
                default:
                    throw new NotImplementedException();
            }
        }
    }

}
