using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using System.Collections.ObjectModel;
using MikuMikuDance.Core.Model;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// MMDBoneManager̃[_
    /// </summary>
    public class MMDBoneManagerReader : ContentTypeReader<MMDBoneManager>
    {
        /// <summary>
        /// {[}l[W̓ǂݍ
        /// </summary>
        /// <param name="input">Rec[_</param>
        /// <param name="existingInstance">IuWFNg</param>
        protected override MMDBoneManager Read(ContentReader input, MMDBoneManager existingInstance)
        {
            List<MMDBone> bones = input.ReadObject<List<MMDBone>>();
            List<MMDIK> iks = input.ReadObject<List<MMDIK>>();
            //{[CfbNX{[IuWFNg
            SkinningHelpers.IKSetup(iks, bones);
#if !XBOX
            return new MMDBoneManager(bones, iks);
#else
            return new MMDXBoxBoneManager(bones, iks);
#endif
        }
        
    }
}
