#!/usr/bin/perl -w
#=============================================================================
#
#	MySQLǡɤ߼
#	MySQL data reader
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

use strict;

use RRDs;

use lib "../..";
require "library/all.pl";

main();

sub main
{
	my %ARGS;
	my $ERROR;

	%ARGS = args_to_options( @ARGV );

	if ( ! -e "rrd/connections.rrd" ||
		 ! -e "rrd/queries.rrd" ||
		 ! -e "rrd/table_cache.rrd" ||
		 ! -e "rrd/key_cache.rrd" ||
		 ! -e "rrd/query_cache.rrd" )
	{
		system( "./makerrd.sh" );
	}

	my %conf = load_configurations( "../../mmeasure.conf" );

	my $db = db_connect( 
		$conf{ 'MYSQL_HOST' }, 
		$conf{ 'MYSQL_USER' }, 
		$conf{ 'MYSQL_PASSWORD' }, 
		$conf{ 'MYSQL_PORT' }, 
		$conf{ 'MYSQL_SOCKET' } );

	my %status = select_2column( $db, "show status" );
	my %variables = select_2column( $db, "show variables" );

	$db->disconnect;

	RRDs::update( "rrd/connections.rrd", "N" . 
		":$status{ 'Threads_connected' }" . 
		":$variables{ 'max_connections' }" . 
		":$status{ 'Max_used_connections' }" . 
		":" . $conf{ 'CONNECTION_RISKY' } * $variables{ 'max_connections' } / 100 . 
		":" . $conf{ 'CONNECTION_LACK' } * $variables{ 'max_connections' } / 100 . 
		":" . $conf{ 'CONNECTION_JUST' } * $variables{ 'max_connections' } / 100 );
	if ( $ERROR = RRDs::error )
	{
		output_log( "die", $ARGS{ 'MODNAME' }, 
			"unable to update `connections.rrd': $ERROR" );
	}

	RRDs::update( "rrd/queries.rrd", "N" . 
		":$status{ 'Questions' }" . 
		":$status{ 'Com_select' }" . 
		":$status{ 'Com_insert' }" . 
		":$status{ 'Com_update' }" . 
		":$status{ 'Com_delete' }" );
	if ( $ERROR = RRDs::error )
	{
		output_log( "die", $ARGS{ 'MODNAME' }, 
			"unable to update `queries.rrd': $ERROR" );
	}

	RRDs::update( "rrd/table_cache.rrd", "N" . 
		":$status{ 'Open_tables' }" . 
		":$variables{ 'table_cache' }" . 
		":$status{ 'Created_tmp_tables' }" . 
		":$status{ 'Created_tmp_disk_tables' }" . 
		":" . $conf{ 'TABLE_CACHE_RISKY' } * $variables{ 'table_cache' } / 100 . 
		":" . $conf{ 'TABLE_CACHE_LACK' } * $variables{ 'table_cache' } / 100 . 
		":" . $conf{ 'TABLE_CACHE_JUST' } * $variables{ 'table_cache' } / 100 );
	if ( $ERROR = RRDs::error )
	{
		output_log( "die", $ARGS{ 'MODNAME' }, 
			"unable to update `table_cache.rrd': $ERROR" );
	}

	RRDs::update( "rrd/key_cache.rrd", "N" . 
		":$status{ 'Key_reads' }" . 
		":$status{ 'Key_read_requests' }" . 
		":$variables{ 'key_buffer_size' }" . 
		":$status{ 'Key_blocks_used' }" . 
		":$status{ 'Select_full_join' }" . 
		":$status{ 'Select_range_check' }" . 
		":$status{ 'Handler_read_key' }" . 
		":$status{ 'Handler_read_rnd' }" . 
		":$status{ 'Slow_queries' }" );
	if ( $ERROR = RRDs::error )
	{
		output_log( "die", $ARGS{ 'MODNAME' }, 
			"unable to update `key_cache.rrd': $ERROR" );
	}

	RRDs::update( "rrd/query_cache.rrd", "N" . 
		":" . ( $variables{ 'query_cache_size' } - $status{ 'Qcache_free_memory' } ) . 
		":$variables{ 'query_cache_size' }" . 
		":" . $conf{ 'QUERY_CACHE_RISKY' } * $variables{ 'query_cache_size' } / 100 . 
		":" . $conf{ 'QUERY_CACHE_LACK' } * $variables{ 'query_cache_size' } / 100 . 
		":" . $conf{ 'QUERY_CACHE_JUST' } * $variables{ 'query_cache_size' } / 100 );
	if ( $ERROR = RRDs::error )
	{
		output_log( "die", $ARGS{ 'MODNAME' }, 
			"unable to update `query_cache.rrd': $ERROR" );
	}

	return 0;
}
