#!/bin/sh
#=============================================================================
#
#	MySQLչ
#	MySQL graph updater
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

. ../../mmeasure.conf

if [ "$IMAGEFORMAT" != "gif" ] && [ "$IMAGEFORMAT" != "png" ]; then IMAGEFORMAT="gif"; fi

OUTDIR="$WEBDIR"
if ! [ "$(ls rrd)" = "" ]; then
	DATABASES=$(ls rrd|awk -F "\\\.rrd$" '{print $1}')
	if ! [ -e $OUTDIR ] ; then mkdir -p $OUTDIR ; fi
	else echo "no databases found to build mysql-stats..."
fi

export LANG=C
DATE=$(date +%s)
DATESTRING=$(date "+%a %Y-%m-%d %H:%M")

GRAPHSIZE_SMALL="-w $WIDTH_SMALL -h $HEIGHT_SMALL"
GRAPHSIZE_LARGE="-w $WIDTH_LARGE -h $HEIGHT_LARGE"

HOUR_END=$(date +%s)
HOUR_START=$((${HOUREND} - 3600))
HOUR_LIMITS="--start ${HOUR_START} --end ${HOUR_END}"

DAY_END=$HOUR_END
DAY_START=$((${DAY_END} - 3600 * 24))
DAY_LIMITS="--start ${DAY_START} --end ${DAY_END}"

WEEK_END=$HOUR_END
WEEK_START=$((${WEEK_END} - 3600 * 24 * 7))
WEEK_LIMITS="--start ${WEEK_START} --end ${WEEK_END}"

MONTH_END=$HOUR_END
MONTH_START=$((${MONTH_END} - 3600 * 24 * 28))
MONTH_LIMITS="--start $((${MONTH_START} - 3600 * 24)) --end ${MONTH_END} --x-grid DAY:1:WEEK:1:DAY:1:0:%e"

YEAR_END=$HOUR_END
YEAR_START=$((${YEAR_END} - 3600 * 24 * 365))
YEAR_LIMITS="--start ${YEAR_START} --end ${YEAR_END}"

title="Connections"

	risky="DEF:risky=rrd/connections.rrd:risky:AVERAGE LINE2:risky${COLOR_RISKY}:risky"

	threads_con="DEF:con=rrd/connections.rrd:Threads_connected:AVERAGE AREA:con${COLOR_CURRENT}:Threads_connected"
	max_con="DEF:mcon=rrd/connections.rrd:max_connections:AVERAGE AREA:mcon${COLOR_GOOD}:max_connections"
	max_used_con="DEF:mucon=rrd/connections.rrd:Max_used:AVERAGE LINE2:mucon${COLOR_MAX}:Max_used_connections"
	consettings="${GRAPHSIZE_SMALL} -l 0 ${max_con} ${threads_con} ${max_used_con} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_connection-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_connection-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_connection-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_connection-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_connection-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${consettings}

	threads_con="DEF:con=rrd/connections.rrd:Threads_connected:AVERAGE AREA:con${COLOR_CURRENT}:Threads_connected GPRINT:con:MIN:(min\:%1.2lf GPRINT:con:MAX:max\:%1.2lf GPRINT:con:AVERAGE:avg\:%1.2lf)\n"
	max_con="DEF:mcon=rrd/connections.rrd:max_connections:AVERAGE AREA:mcon${COLOR_GOOD}:max_connections GPRINT:mcon:MIN:(min\:%1.2lf GPRINT:mcon:MAX:max\:%1.2lf GPRINT:mcon:AVERAGE:avg\:%1.2lf)\n"
	max_used_con="DEF:mucon=rrd/connections.rrd:Max_used:AVERAGE LINE2:mucon${COLOR_MAX}:Max_used_connections GPRINT:mucon:MIN:(min\:%1.2lf GPRINT:mucon:MAX:max\:%1.2lf GPRINT:mucon:AVERAGE:avg\:%1.2lf)\n"
	consettings="${GRAPHSIZE_LARGE} -l 0 ${max_con} ${threads_con} ${max_used_con} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_connection-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_connection-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_connection-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_connection-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${consettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_connection-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${consettings}

title="Queries"

	questions="DEF:question=rrd/queries.rrd:questions:AVERAGE CDEF:questions=question,60,* LINE2:questions${COLOR_CURRENT}:Questions"
	questionssettings="${GRAPHSIZE_SMALL} --vertical-label q/min ${questions}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${questionssettings}

	questions="DEF:question=rrd/queries.rrd:questions:AVERAGE CDEF:questions=question,60,* LINE2:questions${COLOR_CURRENT}:Questions GPRINT:questions:MIN:(min\:%1.2lf GPRINT:questions:MAX:max\:%1.2lf GPRINT:questions:AVERAGE:avg\:%1.2lf)\n"
	questionssettings="${GRAPHSIZE_LARGE} --vertical-label q/min ${questions}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${questionssettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${questionssettings}

title="Data Manipulation"

	select="DEF:select=rrd/queries.rrd:com_select:AVERAGE CDEF:selects=select,60,* LINE2:selects${COLOR_SELECT}:Selects"
	insert="DEF:insert=rrd/queries.rrd:com_insert:AVERAGE CDEF:inserts=insert,60,* LINE2:inserts${COLOR_INSERT}:Inserts"
	update="DEF:update=rrd/queries.rrd:com_update:AVERAGE CDEF:updates=update,60,* LINE2:updates${COLOR_UPDATE}:Updates"
	delete="DEF:delete=rrd/queries.rrd:com_delete:AVERAGE CDEF:deletes=delete,60,* LINE2:deletes${COLOR_DELETE}:Deletes"
	querysettings="${GRAPHSIZE_SMALL} --vertical-label q/min ${select} ${insert} ${update} ${delete}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_data-manipulation-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_data-manipulation-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_data-manipulation-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_data-manipulation-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_data-manipulation-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${querysettings}

	select="DEF:select=rrd/queries.rrd:com_select:AVERAGE CDEF:selects=select,60,* LINE2:selects${COLOR_SELECT}:Selects GPRINT:selects:MIN:(min\:%1.2lf GPRINT:selects:MAX:max\:%1.2lf GPRINT:selects:AVERAGE:avg\:%1.2lf)\n"
	insert="DEF:insert=rrd/queries.rrd:com_insert:AVERAGE CDEF:inserts=insert,60,* LINE2:inserts${COLOR_INSERT}:Inserts GPRINT:inserts:MIN:(min\:%1.2lf GPRINT:inserts:MAX:max\:%1.2lf GPRINT:inserts:AVERAGE:avg\:%1.2lf)\n"
	update="DEF:update=rrd/queries.rrd:com_update:AVERAGE CDEF:updates=update,60,* LINE2:updates${COLOR_UPDATE}:Updates GPRINT:updates:MIN:(min\:%1.2lf GPRINT:updates:MAX:max\:%1.2lf GPRINT:updates:AVERAGE:avg\:%1.2lf)\n"
	delete="DEF:delete=rrd/queries.rrd:com_delete:AVERAGE CDEF:deletes=delete,60,* LINE2:deletes${COLOR_DELETE}:Deletes GPRINT:deletes:MIN:(min\:%1.2lf GPRINT:deletes:MAX:max\:%1.2lf GPRINT:deletes:AVERAGE:avg\:%1.2lf)\n"
	querysettings="${GRAPHSIZE_LARGE} --vertical-label q/min ${select} ${insert} ${update} ${delete}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_data-manipulation-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_data-manipulation-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_data-manipulation-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_data-manipulation-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${querysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_data-manipulation-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${querysettings}

title="Slow Queries"

	slow_queries="DEF:slow=rrd/key_cache.rrd:slow_queries:AVERAGE LINE2:slow${COLOR_BAD}:slow_queries"
	slowsettings="${GRAPHSIZE_SMALL} --vertical-label q/min ${slow_queries}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_slow-query-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_slow-query-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_slow-query-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_slow-query-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_slow-query-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${slowsettings}

	slow_queries="DEF:slow=rrd/key_cache.rrd:slow_queries:AVERAGE LINE2:slow${COLOR_BAD}:slow_queries GPRINT:slow:MIN:(min\:%1.2lf GPRINT:slow:MAX:max\:%1.2lf GPRINT:slow:AVERAGE:avg\:%1.2lf)\n"
	slowsettings="${GRAPHSIZE_LARGE} --vertical-label q/min ${slow_queries}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_slow-query-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_slow-query-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_slow-query-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_slow-query-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${slowsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_slow-query-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${slowsettings}

title="Query Cache"

	risky="DEF:risky=rrd/query_cache.rrd:risky:AVERAGE LINE2:risky${COLOR_RISKY}:risky"

	cache_size="DEF:cachesize=rrd/query_cache.rrd:query_cache_size:AVERAGE AREA:cachesize${COLOR_GOOD}:query_cache_size"
	cache_free="DEF:cachefree=rrd/query_cache.rrd:Qcache_free_memory:AVERAGE AREA:cachefree${COLOR_CURRENT}:query_cache_size-Qcache_free_memory"
	qcachesettings="${GRAPHSIZE_SMALL} -l 0 ${cache_size} ${cache_free} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_query-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${qcachesettings}

	cache_size="DEF:cachesize=rrd/query_cache.rrd:query_cache_size:AVERAGE AREA:cachesize${COLOR_GOOD}:query_cache_size GPRINT:cachesize:MIN:(min\:%1.2lf GPRINT:cachesize:MAX:max\:%1.2lf GPRINT:cachesize:AVERAGE:avg\:%1.2lf)\n"
	cache_free="DEF:cachefree=rrd/query_cache.rrd:Qcache_free_memory:AVERAGE AREA:cachefree${COLOR_CURRENT}:query_cache_size-Qcache_free_memory GPRINT:cachefree:MIN:(min\:%1.2lf GPRINT:cachefree:MAX:max\:%1.2lf GPRINT:cachefree:AVERAGE:avg\:%1.2lf)\n"
	qcachesettings="${GRAPHSIZE_LARGE} -l 0 ${cache_size} ${cache_free} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${qcachesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_query-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${qcachesettings}

title="Table Cache"

	risky="DEF:risky=rrd/table_cache.rrd:risky:AVERAGE LINE2:risky${COLOR_RISKY}:risky"

	table_cache="DEF:mtab=rrd/table_cache.rrd:table_cache:AVERAGE AREA:mtab${COLOR_GOOD}:table_cache"
	open_tables="DEF:tab=rrd/table_cache.rrd:open_tables:AVERAGE AREA:tab${COLOR_CURRENT}:Open_tables"
	tabsettings="${GRAPHSIZE_SMALL} -l 0 ${table_cache} ${open_tables} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_table-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_table-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_table-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_table-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_table-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${tabsettings}

	table_cache="DEF:mtab=rrd/table_cache.rrd:table_cache:AVERAGE AREA:mtab${COLOR_GOOD}:table_cache GPRINT:mtab:MIN:(min\:%1.2lf GPRINT:mtab:MAX:max\:%1.2lf GPRINT:mtab:AVERAGE:avg\:%1.2lf)\n"
	open_tables="DEF:tab=rrd/table_cache.rrd:open_tables:AVERAGE AREA:tab${COLOR_CURRENT}:Open_tables GPRINT:tab:MIN:(min\:%1.2lf GPRINT:tab:MAX:max\:%1.2lf GPRINT:tab:AVERAGE:avg\:%1.2lf)\n"
	tabsettings="${GRAPHSIZE_LARGE} -l 0 ${table_cache} ${open_tables} ${risky}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_table-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_table-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_table-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_table-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${tabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_table-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${tabsettings}

title="Temporary Tables"

	created_tmp_tables="DEF:tmptab=rrd/table_cache.rrd:created_tmp_tables:AVERAGE LINE2:tmptab${COLOR_GOOD}:Created_tmp_tables"
	created_tmp_disk="DEF:tmptabdisk=rrd/table_cache.rrd:created_tmp_disk_t:AVERAGE LINE2:tmptabdisk${COLOR_BAD}:Created_tmp_disk_tables"
	tmptabsettings="${GRAPHSIZE_SMALL} ${created_tmp_tables} ${created_tmp_disk}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_temporary-table-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_temporary-table-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_temporary-table-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_temporary-table-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_temporary-table-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${tmptabsettings}

	created_tmp_tables="DEF:tmptab=rrd/table_cache.rrd:created_tmp_tables:AVERAGE LINE2:tmptab${COLOR_GOOD}:Created_tmp_tables GPRINT:tmptab:MIN:(min\:%1.2lf GPRINT:tmptab:MAX:max\:%1.2lf GPRINT:tmptab:AVERAGE:avg\:%1.2lf)\n"
	created_tmp_disk="DEF:tmptabdisk=rrd/table_cache.rrd:created_tmp_disk_t:AVERAGE LINE2:tmptabdisk${COLOR_BAD}:Created_tmp_disk_tables GPRINT:tmptabdisk:MIN:(min\:%1.2lf GPRINT:tmptabdisk:MAX:max\:%1.2lf GPRINT:tmptabdisk:AVERAGE:avg\:%1.2lf)\n"
	tmptabsettings="${GRAPHSIZE_LARGE} ${created_tmp_tables} ${created_tmp_disk}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_temporary-table-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_temporary-table-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_temporary-table-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_temporary-table-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${tmptabsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_temporary-table-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${tmptabsettings}

title="Reads"

	handler_read_key="DEF:readkey=rrd/key_cache.rrd:handler_read_key:AVERAGE LINE2:readkey${COLOR_GOOD}:Handler_read_key"
	handler_read_rnd="DEF:readrnd=rrd/key_cache.rrd:handler_read_rnd:AVERAGE LINE2:readrnd${COLOR_BAD}:Handler_read_rnd"
	readsettings="${GRAPHSIZE_SMALL} ${handler_read_key} ${handler_read_rnd}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_key-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_key-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_key-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_key-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_key-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${readsettings}

	handler_read_key="DEF:readkey=rrd/key_cache.rrd:handler_read_key:AVERAGE LINE2:readkey${COLOR_GOOD}:Handler_read_key GPRINT:readkey:MIN:(min\:%1.2lf GPRINT:readkey:MAX:max\:%1.2lf GPRINT:readkey:AVERAGE:avg\:%1.2lf)\n"
	handler_read_rnd="DEF:readrnd=rrd/key_cache.rrd:handler_read_rnd:AVERAGE LINE2:readrnd${COLOR_BAD}:Handler_read_rnd GPRINT:readrnd:MIN:(min\:%1.2lf GPRINT:readrnd:MAX:max\:%1.2lf GPRINT:readrnd:AVERAGE:avg\:%1.2lf)\n"
	readsettings="${GRAPHSIZE_LARGE} ${handler_read_key} ${handler_read_rnd}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_key-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_key-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_key-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_key-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${readsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_key-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${readsettings}

title="Key Cache"

	key_reads="DEF:key=rrd/key_cache.rrd:key_reads:AVERAGE "
	key_read_requests="DEF:keyreq=rrd/key_cache.rrd:key_read_requests:AVERAGE "
	key_rate="CDEF:keyrate=key,keyreq,/ HRULE:0.001${COLOR_GOOD} HRULE:0.01${COLOR_BAD} LINE2:keyrate${COLOR_CURRENT}:Key_reads/Key_read_requests"
	keysettings="${GRAPHSIZE_SMALL} ${key_reads} ${key_read_requests} ${key_rate}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${keysettings}

	key_reads="DEF:key=rrd/key_cache.rrd:key_reads:AVERAGE "
	key_read_requests="DEF:keyreq=rrd/key_cache.rrd:key_read_requests:AVERAGE "
	key_rate="CDEF:keyrate=key,keyreq,/ HRULE:0.001${COLOR_GOOD} HRULE:0.01${COLOR_BAD} LINE2:keyrate${COLOR_CURRENT}:Key_reads/Key_read_requests GPRINT:keyrate:MIN:(min\:%1.2lf GPRINT:keyrate:MAX:max\:%1.2lf GPRINT:keyrate:AVERAGE:avg\:%1.2lf)\n"
	keysettings="${GRAPHSIZE_LARGE} ${key_reads} ${key_read_requests} ${key_rate}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-cache-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-cache-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-cache-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-cache-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${keysettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-cache-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${keysettings}

title="Key Buffer"

	key_buffer_size="DEF:mkeybuf=rrd/key_cache.rrd:key_buffer_size:AVERAGE AREA:mkeybuf${COLOR_GOOD}:key_buffer_size"
	key_blocks_used="DEF:keybuf=rrd/key_cache.rrd:key_blocks_used:AVERAGE AREA:keybuf${COLOR_CURRENT}:Key_blocks_used"
	keybufsettings="${GRAPHSIZE_SMALL} --base 1024 ${key_buffer_size} ${key_blocks_used}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-buffer-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-buffer-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-buffer-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-buffer-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_myisam-key-buffer-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${keybufsettings}

	key_buffer_size="DEF:mkeybuf=rrd/key_cache.rrd:key_buffer_size:AVERAGE AREA:mkeybuf${COLOR_GOOD}:key_buffer_size GPRINT:mkeybuf:MIN:(min\:%1.2lf GPRINT:mkeybuf:MAX:max\:%1.2lf GPRINT:mkeybuf:AVERAGE:avg\:%1.2lf)\n"
	key_blocks_used="DEF:keybuf=rrd/key_cache.rrd:key_blocks_used:AVERAGE AREA:keybuf${COLOR_CURRENT}:Key_blocks_used GPRINT:keybuf:MIN:(min\:%1.2lf GPRINT:keybuf:MAX:max\:%1.2lf GPRINT:keybuf:AVERAGE:avg\:%1.2lf)\n"
	keybufsettings="${GRAPHSIZE_LARGE} --base 1024 ${key_buffer_size} ${key_blocks_used}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-buffer-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-buffer-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-buffer-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-buffer-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${keybufsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_myisam-key-buffer-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${keybufsettings}

title="Full Joins"

	select_full_join="DEF:join=rrd/key_cache.rrd:select_full_join:AVERAGE LINE2:join${COLOR_BAD}:Select_full_join"
	joinsettings="${GRAPHSIZE_SMALL} ${select_full_join}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_join-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_join-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_join-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_join-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_join-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${joinsettings}

	select_full_join="DEF:join=rrd/key_cache.rrd:select_full_join:AVERAGE LINE2:join${COLOR_BAD}:Select_full_join GPRINT:join:MIN:(min\:%1.2lf GPRINT:join:MAX:max\:%1.2lf GPRINT:join:AVERAGE:avg\:%1.2lf)\n"
	joinsettings="${GRAPHSIZE_LARGE} ${select_full_join}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_join-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_join-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_join-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_join-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${joinsettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_join-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${joinsettings}

title="Range Checks"

	select_range_check="DEF:range=rrd/key_cache.rrd:select_range_check:AVERAGE LINE2:range${COLOR_BAD}:Select_range_check"
	rangesettings="${GRAPHSIZE_SMALL} ${select_range_check}"

	$PATH_RRDTOOL graph $OUTDIR/small-mysql_range-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} $DATESTRING" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_range-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} $DATESTRING" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_range-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} $DATESTRING" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_range-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} $DATESTRING" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/small-mysql_range-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} $DATESTRING" ${rangesettings}

	select_range_check="DEF:range=rrd/key_cache.rrd:select_range_check:AVERAGE LINE2:range${COLOR_BAD}:Select_range_check GPRINT:range:MIN:(min\:%1.2lf GPRINT:range:MAX:max\:%1.2lf GPRINT:range:AVERAGE:avg\:%1.2lf)\n"
	rangesettings="${GRAPHSIZE_LARGE} ${select_range_check}"

	$PATH_RRDTOOL graph $OUTDIR/large-mysql_range-hour.$IMAGEFORMAT ${HOUR_LIMITS} --title "${title} - last hour ($DATESTRING)" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_range-day.$IMAGEFORMAT ${DAY_LIMITS} --title "${title} - last day ($DATESTRING)" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_range-week.$IMAGEFORMAT ${WEEK_LIMITS} --title "${title} - last week ($DATESTRING)" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_range-month.$IMAGEFORMAT ${MONTH_LIMITS} --title "${title} - last month ($DATESTRING)" ${rangesettings}
	$PATH_RRDTOOL graph $OUTDIR/large-mysql_range-year.$IMAGEFORMAT ${YEAR_LIMITS} --title "${title} - last year ($DATESTRING)" ${rangesettings}

