#=============================================================================
#
#	顼ȥ饤֥
#	Alert library
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: $
#
#=============================================================================

use strict;

#!!!!!!!!!!!!!!!!!!!!!
#	᥽å
#!!!!!!!!!!!!!!!!!!!!!

#-------------------------------------------------------------------------
#	顼ȥ᡼
#-------------------------------------------------------------------------
sub alerter_sendmail
{
	my ( $host, $to, $from, $subject, $body, $cc, $bcc ) = @_;
	my ( $result, $header );

	if ( $host ne "" && $to ne "" && $from ne "" )
	{
		$header = "X-Mailer: mMeasure\n" . 
			"MIME-Version: 1.0\n" . 
			"Content-Type: text/plain; charset=iso-2022-jp\n";
		$result = sendmail( 
			$host, $to, $from, $subject, $body, $cc, $bcc, $header );
	}

	return $result;
}

#-------------------------------------------------------------------------
#	³Ψμ
#-------------------------------------------------------------------------
sub alerter_get_connection
{
	my ( $max_used_connections, $max_connections ) = @_;
	my $result;

	$result = round( $max_used_connections / $max_connections * 100, 2 );

	return $result;
}

#-------------------------------------------------------------------------
#	³ΨȽ
#-------------------------------------------------------------------------
sub alerter_judge_connection
{
	my ( $connection, %conf ) = @_;
	my $result = "none";

	if ( $connection >= $conf{ "CONNECTION_RISKY" } )
	{
		$result = "risky";
	}
	elsif ( $connection >= $conf{ "CONNECTION_LACK" } )
	{
		$result = "lack";
	}
	elsif ( $connection >= $conf{ "CONNECTION_JUST" } )
	{
		$result = "just";
	}
	else
	{
		$result = "overspec";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ơ֥륭åΨμ
#-------------------------------------------------------------------------
sub alerter_get_table_cache
{
	my ( $open_tables, $table_cache ) = @_;
	my $result;

	$result = round( $open_tables / $table_cache * 100, 2 );

	return $result;
}

#-------------------------------------------------------------------------
#	ơ֥륭åΨȽ
#-------------------------------------------------------------------------
sub alerter_judge_table_cache
{
	my ( $table_cache, %conf ) = @_;
	my $result = "none";

	if ( $table_cache >= $conf{ "TABLE_CACHE_RISKY" } )
	{
		$result = "risky";
	}
	elsif ( $table_cache >= $conf{ "TABLE_CACHE_LACK" } )
	{
		$result = "lack";
	}
	elsif ( $table_cache >= $conf{ "TABLE_CACHE_JUST" } )
	{
		$result = "just";
	}
	else
	{
		$result = "overspec";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ƥݥ꡼꡼Ψμ
#-------------------------------------------------------------------------
sub alerter_get_temporary_memory
{
	my ( $created_tmp_tables, $created_tmp_disk_tables ) = @_;
	my $result;

	if ( $created_tmp_tables == 0 || $created_tmp_disk_tables == 0 )
	{
		$result = 0;
	}
	else
	{
		$result = round( 
			( $created_tmp_tables - $created_tmp_disk_tables ) 
				/ $created_tmp_tables * 100, 2 );
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ƥݥ꡼꡼ΨȽ
#-------------------------------------------------------------------------
sub alerter_judge_temporary_memory
{
	my ( $temporary_memory, %conf ) = @_;
	my $result = "just";

	if ( $temporary_memory != 0 )
	{
		if ( $temporary_memory < $conf{ "TEMPORARY_MEMORY_RISKY" } )
		{
			$result = "risky";
		}
		elsif ( $temporary_memory < $conf{ "TEMPORARY_MEMORY_LACK" } )
		{
			$result = "lack";
		}
		elsif ( $temporary_memory < $conf{ "TEMPORARY_MEMORY_JUST" } )
		{
			$result = "just";
		}
		else
		{
			$result = "overspec";
		}
	}

	return $result;
}

#-------------------------------------------------------------------------
#	³Υ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_connection
{
	my ( $judge ) = @_;
	my $result = "ʥɥХκ˼...";

	if ( $judge eq "risky" )
	{
		$result = "max_connectionsΥ䤷Ʋ";
	}
	if ( $judge eq "lack" )
	{
		$result = "max_connectionsΥ䤹ȤǤ¿Ʊ³桼ޤ";
	}
	if ( $judge eq "just" )
	{
		$result = "max_connectionsŬꤵƤޤ";
	}
	if ( $judge eq "overspec" )
	{
		$result = "³Фmax_connections꤬礭ޤ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	꡼Υ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_slow_query
{
	my ( $value ) = @_;
	my $result = "٤꡼䥤ǥåȤäƤʤ꡼Ϥޤ";

	if ( $value > 0 )
	{
		$result = "꡼åơ٤꡼䥤ǥåƲ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ơ֥륭åΨΥ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_table_cache
{
	my ( $judge ) = @_;
	my $result = "ʥɥХκ˼...";

	if ( $judge eq "risky" )
	{
		$result = "table_cacheΥ䤹Ȥǽޤ";
	}
	if ( $judge eq "lack" )
	{
		$result = "table_cacheΥ­ʤʤǽ㲼붲줬ޤ";
	}
	if ( $judge eq "just" )
	{
		$result = "table_cacheŬꤵƤޤ";
	}
	if ( $judge eq "overspec" )
	{
		$result = "table_cache꤬礭ޤ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ƥݥ꡼꡼ΨΥ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_temporary_memory
{
	my ( $judge ) = @_;
	my $result = "ʥɥХκ˼...";

	if ( $judge eq "risky" )
	{
		$result = "tmp_table_sizeΥ䤷ǽƲ";
	}
	if ( $judge eq "lack" )
	{
		$result = "tmp_table_sizeΥ䤹Ȥǽ夹ǽ⤤Ǥ";
	}
	if ( $judge eq "just" )
	{
		$result = "tmp_table_sizeŬꤵƤޤ";
	}
	if ( $judge eq "overspec" )
	{
		$result = "tmp_table_size꤬礭ޤ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ΨΥ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_key
{
	my ( $judge ) = @_;
	my $result = "ʥɥХκ˼...";

	if ( $judge eq "risky" )
	{
		$result = "Ѥʤ׵᤬¿ޤǥååƲ";
	}
	if ( $judge eq "just" )
	{
		$result = "Ŭ˻ѤƤޤ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	Ѥʤ祤Υ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_select_full_join
{
	my ( $value ) = @_;
	my $result = "ƤselectȤäƥ祤󤷤ƤŬʾ֤Ǥ";

	if ( $value > 0 )
	{
		$result = "Ȥ鷺˥祤󤷤ƤselectΤǥǥååƲ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ΥǥåѤΥ塼˥󥰥ɥХ
#-------------------------------------------------------------------------
sub alerter_advise_select_range_check
{
	my ( $value ) = @_;
	my $result = "󥸥å祤󤬤ʤŬʾ֤Ǥ";

	if ( $value > 0 )
	{
		$result = "󥸥å祤󤷤ƤselectΤǥǥååƲ";
	}

	return $result;
}

#-------------------------------------------------------------------------
#	᡼ѥեޥåȤؤ
#-------------------------------------------------------------------------
sub alerter_mail_format_percentage
{
	my ( $label, $message, $value ) = @_;
	my $result;

	$result = "" . $label . " " . $value . " %\n" . $message . "\n\n";

	return $result;
}

#-------------------------------------------------------------------------
#	᡼ѥեޥåȤؤ
#-------------------------------------------------------------------------
sub alerter_mail_format_number
{
	my ( $label, $message, $value ) = @_;
	my $result;

	$result = "" . $label . " " . $value . " \n" . $message . "\n\n";

	return $result;
}

1;
