#=============================================================================
#
#	̥饤֥
#	Common library
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

use strict;

#!!!!!!!!!!!!!!!!!!!!!
#	᥽å
#!!!!!!!!!!!!!!!!!!!!!

#-------------------------------------------------------------------------
#	ͤδݤ
#-------------------------------------------------------------------------
sub round
{
	my ( $value, $digit ) = @_;
	my $result;

	$result = sprintf( "%." . $digit . "f", $value );

	return $result;
}

#-------------------------------------------------------------------------
#	եɤ߹
#-------------------------------------------------------------------------
sub read_file
{
	my ( $file ) = @_;
	my $result;

	$result = "";
	open IN, $file;
	while ( <IN> )
	{
		$result = $result . $_;
	}
	close IN;

	return $result;
}

#-------------------------------------------------------------------------
#	߻μ
#-------------------------------------------------------------------------
sub current
{
	my $result;
	my ( $second, $minute, $hour, $day, $month, $year ) = localtime;

	$result = sprintf( 
		"%04d/%02d/%02d %02d:%02d:%02d", 
		$year + 1900, $month + 1, $day, $hour, $minute, $second);

	return $result;
}

#-------------------------------------------------------------------------
#	ν
#-------------------------------------------------------------------------
sub output_log
{
	my ( $what, $mod, $message ) = @_;

	if ( !defined $mod )
	{
		$mod=get_module_name();
	}
	if ( !defined $message )
	{
		$message = "(unknown reason)";
	}
	if ( $what eq "die" )
	{
		die time." ".$mod.": ".$message."\n";
	}
	elsif ( $what eq "warn" )
	{
		print time . " " . $mod . " " . $what . " " . $message,"\n";
	}
	else
	{
		print time," ",$mod," method \"",$what,"\" not supported.\n";
	}
}

#-------------------------------------------------------------------------
#	Υå
#-------------------------------------------------------------------------
sub check_args
{
	my ( $check, %ARGS ) = @_;
	my $value;

	foreach $value ( split /,/,$check )
	{
		if ( (!defined $ARGS{ $value } ) || ($ARGS{ $value } eq "" ) || ($ARGS{ $value } eq "not configured" ) )
		{
			if ( $value eq "MODNAME" )
			{
				$ARGS{ $value } = get_module_name();
			}
			if ( $value eq "DEBUGLEVEL" )
			{
				$ARGS{ $value } = -1;
			}
			if ( $value eq "OSTYPE" )
			{
				$ARGS{ $value } = identify_os_type();
			}
		}
	}
	return %ARGS;
}

#-------------------------------------------------------------------------
#	ץѤ
#-------------------------------------------------------------------------
sub options_to_args
{
	my ( %opts ) = @_;
	my $result = "";
	my $value;

	foreach $value ( keys( %opts ) )
	{
		if ( index( "DEBUGLEVEL MODNAME OSTYPE", $value ) >= 0)
		{
			$result = $result . 
				" " . $value . "=\"" . $opts{ $value } . "\"";
		}
	}
	if ( $opts{ 'DEBUGLEVEL' } >= 0 )
	{
		print "CLIENT-LINE: $result\n"
	}

	return $result;
}

#-------------------------------------------------------------------------
#	򥪥ץѤ
#-------------------------------------------------------------------------
sub args_to_options
{
	my ( %HASH, $pair, $var, $value );

	foreach $pair ( @_ )
	{
		( $var, $value ) = split /=/, $pair;
		$HASH{ $var } = $value;
	}
	if ( ! defined $HASH{ 'MODNAME' } )
	{
		$HASH{ 'MODNAME' } = get_module_name();
	}
	if ( ! defined $HASH{ 'OSTYPE' } )
	{
		$HASH{ 'OSTYPE' } = `uname`; chomp $HASH{ 'OSTYPE' };
	}
	if ( ! defined $HASH{ 'DEBUGLEVEL' } )
	{
		$HASH{ 'DEBUGLEVEL' } = -1;
	}
	if ( $HASH{ 'DEBUGLEVEL' } >= 6 )
	{
		print "\n";
		foreach ( keys %HASH )
		{
			printf "		 %-15s %s\n", $_, $HASH{ $_ };
		}
	}

	return %HASH;
}

#-------------------------------------------------------------------------
#	⥸塼̾μ
#-------------------------------------------------------------------------
sub get_module_name
{
	my $result = uc `pwd|awk -F "-" '{print \$2}'`;

	chomp $result;

	return $result;
}

#-------------------------------------------------------------------------
#	פʸν
#-------------------------------------------------------------------------
sub strip_unwanted
{
	foreach ( @_ )
	{
		$_ =~ s/ *= */=/g;		# spaces near a =
		$_ =~ s/\"//g;			# " chars
		$_ =~ s/	+/ /g;		# multiple spaces to single
		$_ =~ s/^ *//g;			# spaces at beginning
		$_ =~ s/ *$//g;			# spaces at end
	}

	return @_;
}

#-------------------------------------------------------------------------
#	OSμ
#-------------------------------------------------------------------------
sub identify_os_type
{
	my $result = `uname`;

	chomp $result;

	return $result;
}

1;
