#=============================================================================
#
#	饤֥
#	Configuration library
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

use strict;

#!!!!!!!!!!!!!!!!!!!!!
#	᥽å
#!!!!!!!!!!!!!!!!!!!!!

#-------------------------------------------------------------------------
#	եΥ
#-------------------------------------------------------------------------
sub load_configurations
{
	my ( $conf_file ) = @_;
	my ( $name, $value, %result );

	my @lines = read_configuration_file( $conf_file );
	foreach ( @lines )
	{
		( $name, $value ) = parse_line( $_ );
		$result{ $name } = $value;
	}

	$result{ 'TIMER_GRAPH_UPDATE_MINUTE' } = 60 * correct_configuration_item( "TIMER_GRAPH_UPDATE_MINUTE", "var", "15", "minutes", "diagram rebuild time", %result );
	$result{ 'TIMER_MAIL_RESET_MINUTE' } = 60 * correct_configuration_item( "TIMER_MAIL_RESET_MINUTE", "var", "1440", "minutes", "mail reset time", %result );
	$result{ 'TIMER_ALERT_MAIL_CHECK_SECOND' } = correct_configuration_item( "TIMER_ALERT_MAIL_CHECK_SECOND", "var", "60", "seconds", "module scan time", %result );

	$result{ 'PATH_RRDTOOL' } = correct_configuration_item( "PATH_RRDTOOL", "path", "", "", "path to \"rrdtool\"", %result );

	$result{ 'TIMER_READ_DATA_SECOND' } = correct_configuration_item( "TIMER_READ_DATA_SECOND", "var", "120", "seconds", "data read time", %result );
	$result{ 'TIMER_SCAN_MODULES_SECOND' } = correct_configuration_item( "TIMER_SCAN_MODULES_SECOND", "var", "120", "seconds", "module scan time", %result );

	$result{ 'PATH_MMEASURE' } = correct_configuration_item( "PATH_MMEASURE", "path", "", "", "path to mMeasure", %result );
	$result{ 'PATH_MMEASURE_DAEMON' } = correct_configuration_item( "PATH_MMEASURE_DAEMON", "path", "", "", "path to mMeasure daemon", %result );

	$result{ 'WEBDIR' } = correct_configuration_item( "WEBDIR", "path", "", "", "path to daemon's output directory", %result );
	$result{ 'IMAGEFORMAT' } = correct_configuration_item( "IMAGEFORMAT", "var", "gif", "", "format of generated pictures", %result );

	$result{ 'LOGDIR' } = correct_configuration_item( "LOGDIR", "path", "\$PATH_MMEASURE_DAEMON/log", "", "path to daemon's logfiles", %result );

	$result{ 'PIDFILE' } = correct_configuration_item( "PIDFILE", "var", "\$PATH_MMEASURE_DAEMON/log/daemon-mmeasure.pid", "", "path to daemon's PID file", %result );

	$result{ 'LOGSIZE' } = correct_configuration_item( "LOGSIZE", "var", "500000", "bytes", "max. logfile size", %result );
	$result{ 'LOGBACKUPS' } = correct_configuration_item( "LOGBACKUPS", "var", "4", "", "logfiles to keep as backups", %result );

	$result{ 'DEBUGLEVEL' } = correct_configuration_item( "DEBUGLEVEL", "var", "-1", "", "debug level", %result );

	return %result;
}

#!!!!!!!!!!!!!!!!!!!!!
#	᥽å
#!!!!!!!!!!!!!!!!!!!!!

#-------------------------------------------------------------------------
#	եɤ߹
#-------------------------------------------------------------------------
sub read_configuration_file
{
	my ( $conf_file ) = @_;
	my ( @config, $enable, $comment );

	open CONF, $conf_file 
		or warn "Can't open configuration file.";
	while ( <CONF> )
	{
		chomp;
		( $enable, $comment ) = split /#/;
		if ( ( defined $enable ) && ( index( $enable, "=" ) >= 0 ) )
		{
			push @config, $enable
		}
	}
	close CONF;

	return @config;
}

#-------------------------------------------------------------------------
#	ǥ쥯ȥŸ
#-------------------------------------------------------------------------
sub expand_directory
{
	my ( $value, %conf ) = @_;
	my $result;

	if ( defined $value )
	{
		$result = $value;
		$result =~ s/\$PATH_MMEASURE_DAEMON/$conf{ 'PATH_MMEASURE_DAEMON' }/g;
		$result =~ s/\$PATH_MMEASURE/$conf{ 'PATH_MMEASURE' }/g;
	}

	return $result;
}

#-------------------------------------------------------------------------
#	ܤΥå
#-------------------------------------------------------------------------
sub correct_configuration_item
{
	my ( $name, $type, $default, $unit, $description, %conf ) = @_;

	my $value = $conf{ $name };
	$value = expand_directory( $value, %conf );
	if ( $type eq "path" )
	{
		if ( ( ! defined $value ) || ( $value eq "" ) )
		{
			print $name, " ( ", $description, " ) not configured.\n";
			if ( $default eq "" )
			{
				print "no default value given.\n";
				exit 1;
			}
			else
			{
				print "using default value: ", $default, " ", $unit, "\n";
				( $value = $default ) = ~ s/\$PATH_MMEASURE_DAEMON/$conf{ 'PATH_MMEASURE_DAEMON' }/g;
			}
		}
	}

	if ( $type eq "value" )
	{
		if ( ( ! defined $value ) || ( $value eq "" ) )
		{
			print $name, " ( ", $description, " ) not configured.\n";
			if ( $default eq "" )
			{
				print "no default value given.\n";
				exit 1;
			}
			else
			{
				print "using default value: ", $default, " ", $unit, "\n";
				$value = $default;
			}
		}
	}
	return $value;
}

#-------------------------------------------------------------------------
#	ԤΥѡ
#-------------------------------------------------------------------------
sub parse_line
{
	my ( $line ) = @_;

	chomp $line;
	my ( $enable, $comment ) = split /#/, $line, 2;
	if ( ( ! defined $comment ) || ( $comment eq "" ) )
	{
		if ( index( $line, "#" ) >= 0 )
		{
			$comment = " ";
		}
		else
		{
			$comment = "";
		}
	}
	if ( ( ! defined $enable ) || ( $enable eq "" ) )
	{
		return ( "", "", $comment );
	}
	( $enable ) = strip_unwanted( $enable );
	my ( $var, $value ) = split /=/, $enable, 2;
	$var = "" if ( ! defined $var );
	$value = "" if ( ! defined $value );
	$var = uc $var;

	return ( $var, $value, $comment )
}

1;
