use strict;

sub test_make_header
{
	my $self = shift();
	$self->assert_equals( "From: <from>\nTo: <to>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body" ) );
	$self->assert_equals( "From: <from>\nTo: <to>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "" ) );
	$self->assert_equals( "From: <from>\nTo: <to>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "", "" ) );
	$self->assert_equals( "This is header.From: <from>\nTo: <to>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "", "", "This is header." ) );
	$self->assert_equals( "This is header.From: <from>\nTo: <to>\nCc: <cc>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "cc", "", "This is header." ) );
	$self->assert_equals( "This is header.From: <from>\nTo: <to>\nBcc: <bcc>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "", "bcc", "This is header." ) );
	$self->assert_equals( "This is header.From: <from>\nTo: <to>\nCc: <cc>\nBcc: <bcc>\nSubject: subject\n\nbody", make_header( "from", "to", "subject", "body", "cc", "bcc", "This is header." ) );
}

sub test_decode_linefeed
{
	my $self = shift();
	my $actual;
	$actual = "abcxyz";
	decode_linefeed( \$actual );
	$self->assert_equals( "abcxyz", $actual );
	$actual = "abc\x0Dxyz";
	decode_linefeed( \$actual );
	$self->assert_equals( "abc\nxyz", $actual );
	$actual = "abc\x0Axyz";
	decode_linefeed( \$actual );
	$self->assert_equals( "abc\nxyz", $actual );
	$actual = "abc\x0D\x0Axyz";
	decode_linefeed( \$actual );
	$self->assert_equals( "abc\nxyz", $actual );
}

1;
