<?php
class configuration_tester extends TestCase
{
	function testLoadConfigurationMysql()
	{
		$conf = LoadConfiguration( "mmeasure.conf" );
		$this->assertEquals( "mmeasure", $conf[ 'MYSQL_USER' ] );
		$this->assertEquals( "g8Ut4rp2", $conf[ 'MYSQL_PASSWORD' ] );
		$this->assertEquals( "localhost", $conf[ 'MYSQL_HOST' ] );
		$this->assertEquals( "3306", $conf[ 'MYSQL_PORT' ] );
		$this->assertEquals( "/tmp/mysql.sock", $conf[ 'MYSQL_SOCKET' ] );
	}

	function testLoadConfigurationMail()
	{
		$conf = LoadConfiguration( "mmeasure.conf" );
		$this->assertEquals( "localhost", $conf[ 'MAIL_HOST' ] );
		$this->assertEquals( "from@mmeasure.com", $conf[ 'MAIL_FROM' ] );
		$this->assertEquals( "to@mmeasure.com", $conf[ 'MAIL_TO' ] );
		$this->assertEquals( "cc@mmeasure.com", $conf[ 'MAIL_CC' ] );
		$this->assertEquals( "bcc@mmeasure.com", $conf[ 'MAIL_BCC' ] );
	}

	function testReadConfigurationFile()
	{
		$actual = ReadConfigurationFile( "test1.txt" );
		$this->assertEquals( "test1", $actual[ 0 ] );
		$actual = ReadConfigurationFile( "test2.txt" );
		$this->assertEquals( "test1", $actual[ 0 ] );
		$this->assertEquals( "test2", $actual[ 1 ] );
	}

	function testParseLine()
	{
		$actual = ParseLine( "abc=123" );
		$this->assertEquals( "abc", $actual[ 0 ] );
		$this->assertEquals( "123", $actual[ 1 ] );
		$actual = ParseLine( "xyz=789" );
		$this->assertEquals( "xyz", $actual[ 0 ] );
		$this->assertEquals( "789", $actual[ 1 ] );
	}
}
?>
