#!/usr/bin/env bash
# Initial author of this script: Martin.Vahi@softf1.com
# This script is in the public domain.
#==========================================================================
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )" 
S_FP_ORIG="`pwd`"
S_TIMESTAMP="`date +%Y`_`date +%m`_`date +%d`_T_`date +%H`h_`date +%M`min_`date +%S`s"
#--------------------------------------------------------------------------
if [ "$MMMV_BASHRC_LC_DEVELOPMENT_MACHINE_PSEUDONAME" == "mmmv_dev_machine_0001" ]; then
    echo ""
    echo "Wrong testing machine! Exiting without doing anything."
    echo "GUID=='d480bf7f-5351-424f-872c-b262f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi
#--------------------------------------------------------------------------
func_mmmv_wait_and_sync_t1(){
    wait # for background processes started by this Bash script to exit/finish
    sync # network drives, USB-sticks, etc.
} # func_mmmv_wait_and_sync_t1

func_mmmv_exit_if_not_on_path_t2() { # S_COMMAND_NAME
    local S_COMMAND_NAME=$1
    local S_LOCAL_VARIABLE="`which $S_COMMAND_NAME 2>/dev/null`"
    if [ "$S_LOCAL_VARIABLE" == "" ]; then
        echo ""
        echo "Command \"$S_COMMAND_NAME\" could not be found from the PATH. "
        echo "The execution of this Bash script is aborted."
        echo "GUID=='916afc3a-f9f6-41ba-8d7c-b262f04014e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1;
    fi
} # func_mmmv_exit_if_not_on_path_t2

func_assert_error_code_zero_t1(){
    local S_ERR_CODE=$1 # the "$?"
    local S_GUID_CANDIDATE=$2
    #--------
    # If the "$?" were evaluated in this function, 
    # then it would be "0" even, if it is
    # something else at the calling code.
    if [ "$S_ERR_CODE" != "0" ];then
        echo ""
        echo "Something went wrong. Error code: $S_ERR_CODE"
        echo "Aborting script."
        echo "GUID=='47de0e55-2c54-401f-9a1c-b262f04014e7'"
        echo "S_GUID_CANDIDATE=='$S_GUID_CANDIDATE'"
        echo ""
        cd $S_FP_ORIG
        exit 1
    fi
} # func_assert_error_code_zero_t1

func_assert_folder_exists_t1() {  # S_FP, S_GUID
    local S_FP="$1"
    local S_GUID="$2"
    #------------------------------
    if [ "$S_GUID" == "" ]; then
        echo ""
        echo "The code that calls this function is flawed."
        echo "This function requires 2 parameters: S_FP, S_GUID"
        echo "GUID=='2cceeb93-2eda-4f9d-845c-b262f04014e7'"
        echo ""
        #--------
        cd $S_FP_ORIG
        exit 1 # exiting with an error
    fi
    #------------------------------
    if [ ! -e "$S_FP" ]; then
        if [ -h "$S_FP" ]; then
            echo ""
            echo "The path "
            echo ""
            echo "    $S_FP "
            echo ""
            echo "points to a broken symlink, but a folder "
            echo "or a symlink to a folder is expected."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='2946ade5-388d-4b8e-8e4c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        else
            echo ""
            echo "The folder "
            echo ""
            echo "    $S_FP "
            echo ""
            echo "does not exist."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='e4065a9f-3bea-45e4-955c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        fi
    else
        if [ ! -d "$S_FP" ]; then
            echo ""
            if [ -h "$S_FP" ]; then
                echo "The symlink to an existing file "
            else
                echo "The file "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            echo "exists, but a folder is expected."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='42fca421-c442-44bf-975c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        fi
    fi
} # func_assert_folder_exists_t1


func_assert_file_exists_t1() {  # S_FP, S_GUID
    local S_FP="$1"
    local S_GUID="$2"
    #------------------------------
    if [ "$S_GUID" == "" ]; then
        echo ""
        echo "The code that calls this function is flawed."
        echo "This function requires 2 parameters: S_FP, S_GUID"
        echo "GUID=='293c3505-eaeb-4124-855c-b262f04014e7'"
        echo ""
        #--------
        cd $S_FP_ORIG
        exit 1 # exiting with an error
    fi
    #------------------------------
    if [ ! -e "$S_FP" ]; then
        if [ -h "$S_FP" ]; then
            echo ""
            echo "The path "
            echo ""
            echo "    $S_FP "
            echo ""
            echo "points to a broken symlink, but a file or "
            echo "a symlinkt to a file is expected."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='41c54797-1f06-4490-9e8c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        else
            echo ""
            echo "The file "
            echo ""
            echo "    $S_FP "
            echo ""
            echo "does not exist."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='44e3db35-f0ef-4616-a64c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        fi
    else
        if [ -d "$S_FP" ]; then
            echo ""
            if [ -h "$S_FP" ]; then
                echo "The symlink to the folder "
            else
                echo "The folder "
            fi
            echo ""
            echo "    $S_FP "
            echo ""
            echo "exists, but a file or a symlink to a file is expected."
            echo "GUID==\"$S_GUID\""
            echo "GUID=='57b28f52-e26f-45cf-9e5c-b262f04014e7'"
            echo ""
            #--------
            cd $S_FP_ORIG
            exit 1 # exiting with an error
        fi
    fi
} # func_assert_file_exists_t1


#--------------------------------------------------------------------------
# Common to all of the 3 scripts:
func_mmmv_exit_if_not_on_path_t2 "grep"
func_mmmv_exit_if_not_on_path_t2 "python2"

#--------------------------------------------------------------------------
S_FP_PROJECT_ROOT="`cd $S_FP_DIR/.. ;pwd`"
S_FP_BONNET="$S_FP_PROJECT_ROOT/bonnet"
S_FP_TEMPLATES="$S_FP_BONNET/templates"
S_FN_TEMPLATE_SERVER_SRC_TAR="clean_and_uninitialized_src.tar"
S_FN_TEMPLATE_SERVER_SRC_TAR_XZ="$S_FN_TEMPLATE_SERVER_SRC_TAR.xz"
S_FP_TEMPLATE_SERVER_SRC_TAR_XZ="$S_FP_TEMPLATES/$S_FN_TEMPLATE_SERVER_SRC_TAR_XZ"
S_FN_TEMPLATE_PIP2_TAR_0="python2_pip2_modules_Linux_4_19_0_6_amd64_1_SMP_Debian_4_19_67_2_deb10u2_x86_64_GNU_Linux.tar"
S_FP_TEMPLATE_PIP2_TAR_0="$S_FP_TEMPLATES/$S_FN_TEMPLATE_PIP2_TAR_0"
S_FP_VAR="$S_FP_BONNET/var"
S_FP_TMP="$S_FP_BONNET/tmp_"
S_FP_INSTALL_PYTHON2_MODULES_BASH="$S_FP_PROJECT_ROOT/install_python2_modules.bash"
S_FP_INITIALIZE_ZERONET_SERVER_INSTANCE_BASH="$S_FP_PROJECT_ROOT/initialize_ZeroNet_server_instance.bash"
S_FP_START_ZERONET_SERVER_INSTANCE_BASH="$S_FP_PROJECT_ROOT/start_ZeroNet_server_instance.bash"
S_FP_SERVER_INSTANCES="$S_FP_VAR/server_instances"
S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE="$S_FP_VAR/selected_server_instance"
S_FN_PIP_MODULES_FOLDER="python2_pip2_modules"
S_FP_ZERONET_MODULE_PEERMESSAGE_ZIP="$S_FP_TEMPLATES/PeerMessage-py2-1555703274047.zip"
S_FP_INITIALIZE_SERVER_INSTANCE_BASH="$S_FP_PROJECT_ROOT/initialize_ZeroNet_server_instance.bash"
#--------------------------------------------------------------------------
export PYTHONUSERBASE="$S_FP_VAR/$S_FN_PIP_MODULES_FOLDER"
export PYTHONPATH="$PYTHONUSERBASE:$PYTHONPATH"
#export PYTHONNOUSERSITE="$PYTHONUSERBASE"
export PATH="$PYTHONUSERBASE/bin:$PATH"
#--------------------------------------------------------------------------
# The following 2 assertions will probabilistically fail, as preferred,
# if the scripts are at a wrong location. That is to say, 
# the following assertions additionally test that this script
# resides at a right relative path.

func_assert_file_exists_t1 \
    "$S_FP_INSTALL_PYTHON2_MODULES_BASH" "e5c290fa-4a25-4cd3-851c-b262f04014e7"

func_assert_file_exists_t1 \
    "$S_FP_INITIALIZE_ZERONET_SERVER_INSTANCE_BASH" "541092ee-6531-43ca-a95c-b262f04014e7"

func_assert_file_exists_t1 \
    "$S_FP_START_ZERONET_SERVER_INSTANCE_BASH" "2bb34242-25b7-4f0b-8c5c-b262f04014e7"

func_assert_folder_exists_t1 \
    "$S_FP_TEMPLATES" "501bf004-6224-4edf-802c-b262f04014e7"

#--------------------------------------------------------------------------
func_create_tmp_folder(){
    if [ ! -e "$S_FP_TMP" ]; then
        mkdir -p "$S_FP_TMP"
        func_mmmv_wait_and_sync_t1
    fi
    func_assert_folder_exists_t1 \
       "$S_FP_TMP" "a48787e4-44bc-4d77-b45c-b262f04014e7"
} # func_create_tmp_folder

func_delete_tmp_folder(){
    if [ "`echo \"$S_FP_TMP\" | grep bonnet | grep tmp_ `" != "" ]; then
        rm -fr "$S_FP_TMP"
        func_mmmv_wait_and_sync_t1
    fi
} # func_delete_tmp_folder
func_delete_tmp_folder_and_create_tmp_folder(){
    func_delete_tmp_folder
    func_create_tmp_folder
} # func_delete_tmp_folder_and_create_tmp_folder

#==========================================================================


