#!/usr/bin/env bash
# Initial author of this script: Martin.Vahi@softf1.com
# This script is in the public domain.
#==========================================================================
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
S_FP_ORIG="`pwd`"
S_TIMESTAMP="`date +%Y`_`date +%m`_`date +%d`_T_`date +%H`h_`date +%M`min_`date +%S`s"
#--------------------------------------------------------------------------
if [ "$MMMV_BASHRC_LC_DEVELOPMENT_MACHINE_PSEUDONAME" == "mmmv_dev_machine_0001" ]; then
    echo ""
    echo "Wrong testing machine! Exiting without doing anything."
    echo "GUID=='c53d244e-6a21-4e98-a3ad-f062f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi

source "$S_FP_DIR/bonnet/common.bash"
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

#--------------------------------------------------------------------------
#func_mmmv_exit_if_not_on_path_t2 "grep"
#func_mmmv_exit_if_not_on_path_t2 "python2"
func_mmmv_exit_if_not_on_path_t2 "tar"
func_mmmv_exit_if_not_on_path_t2 "unxz"
func_mmmv_exit_if_not_on_path_t2 "unzip"

#--------------------------------------------------------------------------
if [ ! -e "$PYTHONUSERBASE" ]; then
    echo ""
    echo "Failed to find the Python2 pip2 modules folder"
    echo ""
    echo "    $PYTHONUSERBASE"
    echo ""
    echo "Please run the "
    echo ""
    echo "    $S_FP_INSTALL_PYTHON2_MODULES_BASH --redownload"
    echo ""
    echo "before running this script. Aborting script."
    echo "GUID=='2cedfa75-32fd-4c69-a1ad-f062f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi
#--------------------------------------------------------------------------
S_ARG_0="$1"
if [ "$S_ARG_0" != "" ]; then
    echo ""
    echo "This script does not take any command line arguments."
    echo "Aborting script."
    echo "GUID=='280e8735-437a-4e61-a7ad-f062f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1
fi
#--------------------------------------------------------------------------
S_TMP_0="$S_FP_SERVER_INSTANCES/$S_TIMESTAMP"
S_TMP_1="_ZeroNet_server_instance"
S_FP_SERVER_INSTANCE_FOLDER="$S_TMP_0$S_TMP_1"
S_FP_SERVER_INSTANCE_FOLDER_PLUGINS="$S_FP_SERVER_INSTANCE_FOLDER/plugins"
S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE="$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS/Plugin-PeerMessage-master"
S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE_CORRECTED="$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS/PeerMessage"
#--------------------------------------------------------------------------
if [ -e "$S_FP_SERVER_INSTANCE_FOLDER" ]; then
    echo ""
    echo "The "
    echo ""
    echo "    $S_FP_SERVER_INSTANCE_FOLDER"
    echo ""
    echo "should not pre-exist. Aborting script."
    echo "GUID=='5d94dd10-d7e8-4244-939d-f062f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1
fi
mkdir -p "$S_FP_SERVER_INSTANCE_FOLDER"
func_mmmv_wait_and_sync_t1
func_assert_folder_exists_t1 \
    "$S_FP_SERVER_INSTANCE_FOLDER" "5398ed48-7ab7-426e-93ad-f062f04014e7"
#--------------------------------------------------------------------------
func_delete_tmp_folder_and_create_tmp_folder
#----------------------------
cp "$S_FP_TEMPLATE_SERVER_SRC_TAR_XZ" "$S_FP_TMP/"
func_assert_error_code_zero_t1 "$?" "ca1f805a-7076-46da-b2ad-f062f04014e7"
func_mmmv_wait_and_sync_t1
cd "$S_FP_TMP"
    unxz "./$S_FN_TEMPLATE_SERVER_SRC_TAR_XZ"
    func_assert_error_code_zero_t1 "$?" "370b1575-ef0c-463d-a19d-f062f04014e7"
    func_mmmv_wait_and_sync_t1
    tar -xf "./$S_FN_TEMPLATE_SERVER_SRC_TAR"
    func_assert_error_code_zero_t1 "$?" "f15a74f5-daaa-4d3b-b29d-f062f04014e7"
    func_mmmv_wait_and_sync_t1
    cp -f -R "$S_FP_TMP"/the_src/* "$S_FP_SERVER_INSTANCE_FOLDER/"
    func_assert_error_code_zero_t1 "$?" "1c876118-0a60-43f8-b49d-f062f04014e7"
    func_mmmv_wait_and_sync_t1
cd "$S_FP_PROJECT_ROOT"    
func_delete_tmp_folder_and_create_tmp_folder
#----------------------------
func_assert_folder_exists_t1  \
   "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS" "1d55f645-9149-4fa7-a29d-f062f04014e7"

cd "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS"
    unzip "$S_FP_ZERONET_MODULE_PEERMESSAGE_ZIP"  1> /dev/null
    func_assert_error_code_zero_t1 "$?" "8035233d-84a8-4324-a19d-f062f04014e7"
    func_mmmv_wait_and_sync_t1
cd "$S_FP_PROJECT_ROOT"    

func_assert_folder_exists_t1  \
   "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE" "e4d1a3f0-d91a-44e4-a59d-f062f04014e7"

mv "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE" "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE_CORRECTED"
func_assert_error_code_zero_t1 "$?" "3d2f77c3-9ddb-476a-a39d-f062f04014e7"
func_mmmv_wait_and_sync_t1

func_assert_folder_exists_t1  \
   "$S_FP_SERVER_INSTANCE_FOLDER_PLUGINS_PEERMESSAGE_CORRECTED" "343813f2-4d6c-4d1b-a79d-f062f04014e7"

#----------------------------
rm -f "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"
func_assert_error_code_zero_t1 "$?" "96296e10-9776-4661-929d-f062f04014e7"
func_mmmv_wait_and_sync_t1
ln -s "$S_FP_SERVER_INSTANCE_FOLDER" "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"
func_assert_error_code_zero_t1 "$?" "213bf3b3-7215-4f12-849d-f062f04014e7"
func_mmmv_wait_and_sync_t1

# Symlinks to folders also pass.
func_assert_folder_exists_t1  \
   "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE" "14724fb2-4c4c-4f8b-8a9d-f062f04014e7"
#--------------------------------------------------------------------------
func_delete_tmp_folder 
cd "$S_FP_ORIG"
#==========================================================================

