#!/usr/bin/env bash
# Initial author of this script: Martin.Vahi@softf1.com
# This script is in the public domain.
#==========================================================================
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
S_FP_ORIG="`pwd`"
#S_TIMESTAMP="`date +%Y`_`date +%m`_`date +%d`_T_`date +%H`h_`date +%M`min_`date +%S`s"
#--------------------------------------------------------------------------
if [ "$MMMV_BASHRC_LC_DEVELOPMENT_MACHINE_PSEUDONAME" == "mmmv_dev_machine_0001" ]; then
    echo ""
    echo "Wrong testing machine! Exiting without doing anything."
    echo "GUID=='57e92c52-106c-4cf3-a716-c162f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi

source "$S_FP_DIR/bonnet/common.bash"
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

#--------------------------------------------------------------------------
#func_mmmv_exit_if_not_on_path_t2 "grep"
func_mmmv_exit_if_not_on_path_t2 "pip2"
#func_mmmv_exit_if_not_on_path_t2 "python2"
func_mmmv_exit_if_not_on_path_t2 "tar"

#--------------------------------------------------------------------------
func_pip_install(){
    local S_ARG_0="$1"
    local S_ARG_1="$2"
    if [ "$S_ARG_1" == "" ]; then 
        nice -n10 python2 -m pip install "$S_ARG_0"
    else
        nice -n10 python2 -m pip install "$S_ARG_0" "$S_ARG_1"
    fi
    func_mmmv_wait_and_sync_t1
} # func_pip_install
#------------------------------------------
S_FP_0="$S_FP_PROJECT_ROOT/bonnet/list_of_required_pip_packages.txt"
func_assert_file_exists_t1 \
    "$S_FP_0" "e4227a0b-46a3-4605-8956-c162f04014e7"

#------------------------------------------
func_delete_python2_pip2_modules_folder(){
    if [ "`echo \"$PYTHONUSERBASE\" | grep var | grep _pip2_ `" != "" ]; then
        rm -fr "$PYTHONUSERBASE"
        func_mmmv_wait_and_sync_t1 # USB-drives, network drives, etc.
    fi
} # func_delete_python2_pip2_modules_folder

func_print_help_msg_t1(){
    echo ""
    echo "COMMANDLINE_ARGUMENTS::= --redownload | --update | --from_template | --help "
    echo ""
} # func_print_help_msg_t1
#------------------------------------------
S_ARG_0="$1"
SB_ARG_0_VALID="f"
#------------------------------------------
if [ "$S_ARG_0" == "-?" ]; then
    S_ARG_0="--help" # normalization
fi
if [ "$S_ARG_0" == "-h" ]; then
    S_ARG_0="--help" # normalization
fi
if [ "$S_ARG_0" == "h" ]; then
    S_ARG_0="--help" # normalization
fi
if [ "$S_ARG_0" == "help" ]; then
    S_ARG_0="--help" # normalization
fi
#----------
if [ "$S_ARG_0" == "--help" ]; then
    func_print_help_msg_t1
    #SB_ARG_0_VALID="t" # not forgotten, but useless
    exit 0
fi
#------------------------------------------
# The temporary folder cration and old temporary folder
# deletion is after the help command, because the help command 
# should not be bogged down  by network drives or 
# SD-card access or USB-storage access.
func_delete_tmp_folder
#------------------------------------------
if [ "$S_ARG_0" == "-f" ]; then
    S_ARG_0="--redownload" # normalization
fi
if [ "$S_ARG_0" == "-rd" ]; then
    S_ARG_0="--redownload" # normalization
fi
if [ "$S_ARG_0" == "rd" ]; then
    S_ARG_0="--redownload" # normalization
fi
if [ "$S_ARG_0" == "redownload" ]; then
    S_ARG_0="--redownload" # normalization
fi
if [ "$S_ARG_0" == "--redownload" ]; then
    SB_ARG_0_VALID="t"
fi
#------------------------------------------
if [ "$S_ARG_0" == "-u" ]; then
    S_ARG_0="--update" # normalization
fi
if [ "$S_ARG_0" == "u" ]; then
    S_ARG_0="--update" # normalization
fi
if [ "$S_ARG_0" == "upgrade" ]; then
    S_ARG_0="--update" # normalization
fi
if [ "$S_ARG_0" == "--upgrade" ]; then
    S_ARG_0="--update" # normalization
fi
if [ "$S_ARG_0" == "update" ]; then
    S_ARG_0="--update" # normalization
fi
if [ "$S_ARG_0" == "--update" ]; then
    SB_ARG_0_VALID="t"
fi
#------------------------------------------
if [ "$S_ARG_0" == "--ft" ]; then
    S_ARG_0="--from_template" # normalization
fi
if [ "$S_ARG_0" == "-ft" ]; then
    S_ARG_0="--from_template" # normalization
fi
if [ "$S_ARG_0" == "ft" ]; then
    S_ARG_0="--from_template" # normalization
fi
if [ "$S_ARG_0" == "from_template" ]; then
    S_ARG_0="--from_template" # normalization
fi
if [ "$S_ARG_0" == "--from_template" ]; then # restore from template 0
    func_delete_python2_pip2_modules_folder
    SB_ARG_0_VALID="t"
    func_delete_tmp_folder_and_create_tmp_folder
    cp "$S_FP_TEMPLATE_PIP2_TAR_0" "$S_FP_TMP/"
    func_assert_error_code_zero_t1 "$?" "d2d3f40c-fdc8-4e6d-9626-c162f04014e7"
    func_mmmv_wait_and_sync_t1 
    cd "$S_FP_TMP"
        tar -xf "./$S_FN_TEMPLATE_PIP2_TAR_0"
        func_assert_error_code_zero_t1 "$?" "b51beb03-1adf-46e8-a425-c162f04014e7"
        mkdir -p "$S_FP_VAR"
        func_assert_error_code_zero_t1 "$?" "56186a13-01b1-4b8b-b915-c162f04014e7"
        func_mmmv_wait_and_sync_t1 
        cp -f -R "$S_FP_TMP/$S_FN_PIP_MODULES_FOLDER" "$PYTHONUSERBASE"
        func_assert_error_code_zero_t1 "$?" "a33857b7-ff2b-4cc5-8f55-c162f04014e7"
        func_mmmv_wait_and_sync_t1 
    cd "$S_FP_PROJECT_ROOT"
fi
#------------------------------------------
if [ "$SB_ARG_0_VALID" == "f" ]; then 
    echo ""
    echo "This script does not support the command line argument $S_ARG_0"
    echo "Valid command line arguments:"
    func_print_help_msg_t1
    echo "Aborting script."
    echo "GUID=='1db03383-3687-48f0-ac46-c162f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1
else
    if [ "$SB_ARG_0_VALID" != "t" ]; then 
        echo ""
        echo "The code of this script is flawed."
        echo "   SB_ARG_0_VALID==$SB_ARG_0_VALID"
        echo "GUID=='2cf6db11-13f6-4eb8-9136-c162f04014e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1
    fi
fi

#------------------------------------------
if [ ! -e "$PYTHONUSERBASE" ]; then
    mkdir -p $PYTHONUSERBASE 
    func_assert_error_code_zero_t1 "$?" "eb1151d0-40a0-4f3d-b895-c162f04014e7"
    func_mmmv_wait_and_sync_t1
    if [ ! -e "$PYTHONUSERBASE" ]; then
        echo ""
        echo "The PYTHONUSERBASE (== "
        echo "$PYTHONUSERBASE"
        echo ") is missing. and its creation also failed."
        echo "GUID=='59a25132-f7a5-45a2-9715-c162f04014e7'"
        echo ""
    fi
fi
#------------------------------------------
func_pip_install_list(){
    mkdir -p $PYTHONUSERBASE 
    func_assert_error_code_zero_t1 "$?" "5637575b-e80d-4004-b915-c162f04014e7"
    func_mmmv_wait_and_sync_t1
    #--------------------------------------
    func_pip_install "setuptools"
    func_pip_install "wheel"
    func_pip_install "tornado"
    func_pip_install "gevent"
    func_pip_install "-r"  "$S_FP_0"
    #--------------------------------------
    func_mmmv_wait_and_sync_t1
} # func_pip_install_list
if [ "$S_ARG_0" == "--redownload" ]; then
    func_delete_python2_pip2_modules_folder
    func_pip_install_list
fi
if [ "$S_ARG_0" == "--update" ]; then
    func_pip_install_list
fi
func_delete_tmp_folder
#--------------------------------------------------------------------------
cd "$S_FP_ORIG"
#==========================================================================

