/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: NichDatParser.h 1752 2006-10-07 09:33:53Z svn $
 *****************************************************************************/

#ifndef NICH_DAT_PARSER_H
#define NICH_DAT_PARSER_H

#include "Environment.h"

#include "BBSThread.h"

using namespace std;

/**
 * @brief BBS のスレッドをファイルに書き込むクラス．
 */
class NichDatParser
{
public:
    /**
     * コンストラクタです．
     *
     * @param[in] pool プール
     * @param[in] dir_path スレッドを保存するディレクトリ
     */
    NichDatParser(apr_pool_t *pool);

    /**
     * スレッドを書き出します．
     *
     * @param[in] thread_id スレッド ID
     * @param[in] dat_data スレッドデータ
     * @param[in] dat_size スレッドデータのサイズ
     */
    BBSThread *parse(apr_size_t thread_id, const char *dat_data,
                     apr_size_t dat_size);
    void parse_line(BBSThread *bbs_thread, const char *dat_line, apr_size_t line_size);
private:
    static const char LINE_SEPARATOR[];
    static const char COLUMN_SEPARATOR[];
    static const apr_size_t NAME_PARAM_INDEX;
    static const apr_size_t EMAIL_PARAM_INDEX;
    static const apr_size_t MESSAGE_PARAM_INDEX;

    apr_pool_t *pool_;
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
