/******************************************************************************
 * mod_uploader / CharCodeConverter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CharCodeConverter.h 352 2005-05-07 07:21:11Z svn $
 *****************************************************************************/

#ifndef CHARCODECONVERTER_H
#define CHARCODECONVERTER_H

#include "apr_pools.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * ʸɤѴԤ饹
 */
class CharCodeConverter
{
public:
    static const char DEFAULT_CODE[];

    static const char *convert(apr_pool_t *pool, const char *str,
                               const char *pat);
    static const char *convert(apr_pool_t *pool, const char *str,
                               const char *from, const char *to);

private:
    static const unsigned char EUCJP_PAT_FIRST;
    static const unsigned char SJIS_PAT_FIRST;
    static const unsigned char JIS_PAT_FIRST;
    static const unsigned char UTF8_PAT_FIRST;

    static const char *identify_code(const unsigned char *pat);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
