/******************************************************************************
 * mod_uploader / TemplateExecutor.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateExecutor.h 355 2005-05-08 05:19:50Z svn $
 *****************************************************************************/

#ifndef TEMPLATEEXECUTOR_H
#define TEMPLATEEXECUTOR_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "TemplateParser.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "httpd.h"
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "apr_pools.h"
#include "apr_hash.h"
#include "apr_tables.h"

#include <cstdlib>
#include <vector>
#include <map>

using namespace std;

/**
 * ƥץ졼Ȥ¹Ԥ륯饹
 */
class TemplateExecutor
{
public:
    enum variable_type {
        SCALAR,                 // 
        ARRAY,                  // 
        HASH,                   // ϥå
    };

    enum scalar_type {
        STRING,                 // ʸ
        INTEGER,                // 
    };

    typedef TemplateParser::ident_map ident_map;
    typedef TemplateParser::node node;

    struct Variable;
    typedef vector<struct Variable *> variable_map;

    typedef struct Scalar {
        scalar_type type;
        union {
            int i_val;
            const char *s_val;
        };
    } scalar;

    typedef struct Variable {
        variable_type type;
        union {
            apr_array_header_t *a_val;
            apr_hash_t *h_val;
            scalar *s_val;
        };
    } variable;

    TemplateExecutor();
    void exec(apr_pool_t *pool, request_rec *request, node *node,
              ident_map *imap, variable_map *vmap);

    static apr_size_t get_ident_id(ident_map *imap, const char *name);
private:
    static const apr_size_t VARIABLE_POOL_NUM;
    static const apr_size_t SCALAR_POOL_NUM;

    typedef struct Handle {
    public:
        apr_pool_t * const pool;
        request_rec * const request;
        ident_map * const imap;
        variable_map * const vmap;

        variable *variable_pool;
        variable *variable_pool_end;
        scalar *scalar_pool;
        scalar *scalar_pool_end;

        Handle(apr_pool_t *pool, request_rec *request, ident_map *imap, variable_map *vmap)
            : pool(pool),
              request(request),
              imap(imap),
              vmap(vmap)
        {
            variable_pool       = NULL;
            variable_pool_end   = NULL;
            scalar_pool         = NULL;
            scalar_pool_end     = NULL;
        }
    } handle;

    TemplateExecutor(const TemplateExecutor &);
    TemplateExecutor &operator=(const TemplateExecutor &);

    static void exec_stmt(handle *h, node *node);
    static void exec_foreach(handle *h, node *node);
    static void exec_while(handle *h, node *node);
    static void exec_if(handle *h, node *node);
    static void exec_print(handle *h, node *node);
    static bool calc_b_val(handle *h, node *node);
    static int calc_i_val(handle *h, node *node);
    static int calc_i_val(variable* var);
    static variable *get_var(handle *h, node *node);
    static variable *create_variable(handle *h, variable_type type);
    static scalar *create_scalar(handle *h, scalar_type type);
    static void print(handle *h, int i_val);
    static void print(handle *h, const char *s_val);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
