/******************************************************************************
 * mod_uploader / UploadItemWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemWriter.h 352 2005-05-07 07:21:11Z svn $
 *****************************************************************************/

#ifndef UPLOADITEMWRITER_H
#define UPLOADITEMWRITER_H

#include "UploadItem.h"

#include "apr_pools.h"
#include "apr_global_mutex.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * åץɥƥν񤭽ФԤ饹
 */
class UploadItemWriter
{
 public:
    UploadItemWriter(apr_pool_t *pool, const char *file_dir);
    const char* write(UploadItem::header *header, const char *tmp_path);
 private:
    static const char FILE_NAME_TEMPLATE[];

    UploadItemWriter(const UploadItemWriter &);
    UploadItemWriter &operator=(const UploadItemWriter &);

    void write_date(UploadItem::header *header, const char *file_path, const char *tmp_path);
    static const char *create_file_name(apr_pool_t *pool, const char *file_dir);

    apr_pool_t * const pool_;
    const char * const file_dir_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
