/******************************************************************************
 * mod_uploader / UploadItem.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItem.h 466 2005-07-17 05:11:07Z svn $
 *****************************************************************************/

#ifndef UPLOADITEM_H
#define UPLOADITEM_H

#include "apr_pools.h"
#include "apr_time.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץɥƥɽ饹
 */
class UploadItem
{
    friend class TemplateVariableCreator;
    friend class UploadItemCreator;

public:
    static const apr_size_t MAX_VERSION_LENGTH          = 8;
    static const apr_size_t MAX_FILE_MIME_LENGTH        = 64;
    static const apr_size_t MAX_FILE_NAME_LENGTH        = 64;
    static const apr_size_t MAX_REMOVE_PASS_LENGTH      = 16;
    static const apr_size_t MAX_DOWNLOAD_PASS_LENGTH    = 16;
    static const apr_size_t MAX_COMMENT_LENGTH          = 256;
    static const apr_size_t ITEM_HEADER_SIZE            = 512; // ;͵Ƥ

    static const char FILE_PARAM[];
    static const char COMMENT_PARAM[];
    static const char REMOVE_PASS_PARAM[];
    static const char DOWNLOAD_PASS_PARAM[];
    static const char CODE_PAT_PARAM[];

    typedef struct Header {
        char                identifier[(sizeof(PACKAGE_NAME)/4 + 1)*4];
        char                version[MAX_VERSION_LENGTH];
        apr_size_t          file_size;
        apr_time_t          time;
        char                file_mime[MAX_FILE_MIME_LENGTH];
        char                file_name[MAX_FILE_NAME_LENGTH];
        char                remove_pass[MAX_REMOVE_PASS_LENGTH];
        char                download_pass[MAX_DOWNLOAD_PASS_LENGTH];
        char                comment[MAX_COMMENT_LENGTH];
    } header;

    UploadItem(apr_pool_t *pool, const char *file_path, header *header);
    explicit UploadItem(apr_pool_t *pool);
    header *set_data(const char *file_path, header *header);
    header *get_header();
    const char *get_file_path();
    const char *get_file_name();
    const char *get_comment();
    const char *get_remove_pass();
    const char *get_download_pass();
    const char *get_file_size();
    const char *get_file_mime();
    const char *get_time();
#ifdef DEBUG
    static void dump_header(header *header);
#endif

private:
    static const char FILE_NAME_KEY[];
    static const char FILE_PATH_KEY[];
    static const char REMOVE_PASS_KEY[];
    static const char DOWNLOAD_PASS_KEY[];
    static const char COMMENT_KEY[];
    static const char FILE_SIZE_KEY[];
    static const char FILE_MIME_KEY[];
    static const char TIME_KEY[];

    static const apr_size_t TIME_ZONE_OFFSET;
    static const apr_size_t MAX_TIME_LENGTH;
    static const char TIME_FORMAT[];

    UploadItem(const UploadItem&);
    UploadItem &operator=(const UploadItem&);

    apr_pool_t * const pool_;
    const char *file_path_;
    header *header_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
