/******************************************************************************
 * mod_uploader / BinString.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BinString.cpp 452 2005-07-10 18:06:57Z svn $
 *****************************************************************************/

#include "BinString.h"

#ifdef DEBUG
#include <iostream>
#endif

const apr_size_t BinString::DEFAULT_SIZE    = 1024;


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
BinString::BinString(apr_size_t size)
    : buffer_(NULL),
      size_(0)
{
    reserve(size);
}

BinString::~BinString()
{
    if (buffer_  != NULL) {
        free(buffer_);
    }
}

void BinString::reserve(apr_size_t size)
{
#ifdef DEBUG
    if (size < size_) {
        throw "¸ΤΤ⥵Хåե׵ᤵޤ";
    }
#endif

    if (size == 0) {
        if (buffer_ != NULL) {
            free(buffer_);
            buffer_ = NULL;
        }
    } else if (buffer_ == NULL) {
        buffer_ = alloc(size);
    } else {
        char *swap = buffer_;

        try {
            buffer_ = alloc(size);
            memcpy(buffer_, swap, size_);
            free(swap);
        } catch(const char *) {
            free(swap);
            throw;
        }
    }
    buf_size_ = size;
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
char *BinString::alloc(apr_size_t size)
{
    char *buffer = static_cast<char *>(malloc(sizeof(char *)*size));

    if (buffer == NULL) {
        throw "γݤ˼Ԥޤ";
    }

    return buffer;
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
