###############################################################################
# mod_uploader / upload-item.rb
###############################################################################
# Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
#
# All rights reserved.
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any
# damages arising from the use of this software.
#
# Permission is granted to anyone to use this software for any
# purpose, including commercial applications, and to alter it and
# redistribute it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must
#    not claim that you wrote the original software. If you use this
#    software in a product, an acknowledgment in the product
#    documentation would be appreciated but is not required.
#
# 2. Altered source versions must be plainly marked as such, and must
#    not be misrepresented as being the original software.
#
# 3. This notice may not be removed or altered from any source
#    distribution.
#
# $Id: upload-item.rb 430 2005-07-03 20:24:04Z svn $
###############################################################################

class UploadItem
  attr_reader :file_path, :file_name, :file_mime, :comment, :remove_pass, :download_pass

  def initialize(file_path, file_name, file_mime, file_size, time, comment, remove_pass, download_pass)
    @file_path      = file_path
    @file_name      = file_name
    @file_mime      = file_mime
    @file_size      = file_size
    @time           = time
    @comment        = comment
    @remove_pass	= remove_pass
    @download_pass  = download_pass
  end

  def file_size_num
    @file_size
  end

  def time_num
    @time
  end

  def to_h
    {
      "file_path"       => file_path,
      "file_name"       => file_name,
      "file_mime"       => file_mime,
      "file_size"       => file_size,
      "time"            => time,
      "comment"         => comment,
      "remove_pass"	    => remove_pass,
      "download_pass"   => download_pass,
    }
  end
end

class UploadItemList
  def self.load(file_dir)
    reader = UploadItemReader.new(file_dir)
    file_list = Dir.entries(file_dir).delete_if {|file| /^\./ =~ file }

    self.new(file_dir, file_list.sort!.reverse!.map {|item| reader.read(item)})
  end

  def initialize(file_dir, item_list)
    @file_dir   = file_dir
    @item_list  = item_list
  end

  def to_h(start, size)
    @item_list[start, size]
  end

  def size
    @item_list.size
  end
  
  def remove(file_path, password)
    item = @reader.read(file_path)
    
    if password != item.remove_pass then
      raise Exception.new("ѥɤ㤤ޤ")
    end

    remove(file_path)
  end

  def remove(file_path)
    item = @item_list.find {|item| item.file_path == file_path }

    if item == nil then
      raise Exception.new("åץɥե¸ߤޤ")
    end

    File.unlink(@file_dir + "/" + file_path)
    @item_list.delete(item)
  end

  def total_file_size_impl
    total = 0
    @item_list.each {|item| total += item.file_size_num }

    total
  end

  private :total_file_size_impl
end

class UploadItemReader
  def initialize(file_dir)
    @file_dir   = file_dir
  end
end

require "UploadItem.so"

# local Variables:
# mode: ruby
# buffer-file-coding-system: euc-japan-dos
# End:
