/******************************************************************************
 * mod_uploader / Auxiliary.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: Auxiliary.h 352 2005-05-07 07:21:11Z svn $
 *****************************************************************************/

#ifndef AUXILIARY_H
#define AUXILIARY_H

#include <limits.h>
#ifndef PATH_MAX
#define PATH_MAX 255
#endif

#include "apr_pools.h"

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif
const char *rfc1738_encode(apr_pool_t *pool, const char* str);
const char *size_str(apr_pool_t *pool, apr_uint64_t size);
const char *comma_str(apr_pool_t *pool, apr_size_t number);
const char *basename_ex(const char *path);
const char *dirname_ex(apr_pool_t *pool, const char *path);
#ifndef HAVE_STRNSTR
char *strnstr(const char * const s, const char * const p, size_t count);
#endif
#ifndef HAVE_STRNCHR
char *strnchr(const char *s, size_t count, int c);
#endif
#if !defined(HAVE_MEMMEM) || defined(WIN32)
void *memmem(const void *haystack, size_t haystacklen,
             const void *needle, size_t needlelen);
#endif
#ifdef __cplusplus
}
#endif

#endif

/*
 * Local Variables:
 * mode: c++
 * buffer-file-coding-system: euc-japan-dos
 * End:
 */
