/******************************************************************************
 * mod_uploader / UploadItemList.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemList.h 479 2005-07-23 12:53:27Z svn $
 *****************************************************************************/

#ifndef UPLOADITEMLIST_H
#define UPLOADITEMLIST_H

#include "UploadItem.h"
#include "UploadItemReader.h"
#include "TemplateExecutor.h"

#include "apr_pools.h"

#include <cstdlib>
#include <list>
#include <string>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief åץɥƥδԤ饹
 */
class UploadItemList
{
public:
    typedef struct ItemInfo {
        UploadItem::header *header;
        const char *file_path;
    } item_info;

    UploadItemList(apr_pool_t *pool,
                   const char *file_dir, const char *thumb_dir,
                   apr_size_t total_number_limit, apr_uint64_t total_size_limit);
    void add(const char *file_path, bool is_make_thumb=false);
    apr_size_t size() const;
    apr_size_t thumb_size() const;
    apr_uint64_t total_file_size() const;
    apr_time_t get_mtime() const;
    void remove(const char *file_path, const char *password);
    TemplateExecutor::variable *to_varray(apr_pool_t *pool,
                                          apr_size_t start,
                                          apr_size_t size) const;
    TemplateExecutor::variable *to_thumb_varray(apr_pool_t *pool,
                                                apr_size_t start,
                                                apr_size_t size) const;
    item_info **to_array(apr_pool_t *pool, apr_size_t start, apr_size_t size) const;

    static UploadItemList *load(apr_pool_t *pool,
                                const char *file_dir, const char *thumb_dir,
                                apr_size_t total_number_limit,
                                apr_uint64_t total_size_limit);
#ifdef DEBUG
    static void dump_list(UploadItemList *item_list);
#endif
private:
    struct ItemCompare
    {
        bool operator()(const item_info *lhs, const item_info *rhs) const
        {
            return lhs->header->time > rhs->header->time;
        }
    };

    struct ThumbnailCompare
    {
        bool operator()(const string& lhs, const string& rhs) const
        {
            return lhs > rhs;
        }
    };

    typedef list<item_info *> item_list;
    typedef item_list::const_iterator item_iterator;
    typedef list<string> thumb_list;
    typedef thumb_list::const_iterator thumb_iterator;

    UploadItemList(const UploadItemList&);
    UploadItemList &operator=(const UploadItemList&);

    void init();
    item_iterator begin() const;
    item_iterator end() const;
    void remove(item_info *info);

    apr_pool_t *pool_;
    const char *file_dir_;
    const char *thumb_dir_;
    const apr_size_t total_number_limit_;
    const apr_uint64_t total_size_limit_;

    UploadItemReader reader;
    apr_uint64_t total_size_;
    apr_time_t mtime_;
    item_list ilist_;
    thumb_list tlist_;
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
