/******************************************************************************
 * mod_uploader / TemplateVariableCreator.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: TemplateVariableCreator.cpp 468 2005-07-18 10:11:42Z svn $
 *****************************************************************************/

#include "TemplateVariableCreator.h"
#include "TemplateExecutor.h"

#include "apr_hash.h"

#ifdef DEBUG
#include <iostream>
#endif

/******************************************************************************
 * public ᥽å
 *****************************************************************************/
TemplateVariableCreator::variable *TemplateVariableCreator::create(apr_pool_t *pool, UploadItem *item)
{
    apr_hash_t *hash = apr_hash_make(pool);

    apr_hash_set(hash, UploadItem::FILE_NAME_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_file_name()));
    apr_hash_set(hash, UploadItem::FILE_PATH_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_file_path()));
    apr_hash_set(hash, UploadItem::COMMENT_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_comment()));
    apr_hash_set(hash, UploadItem::REMOVE_PASS_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_remove_pass()));
    apr_hash_set(hash, UploadItem::DOWNLOAD_PASS_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_download_pass()));
    apr_hash_set(hash, UploadItem::FILE_SIZE_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_file_size()));
    apr_hash_set(hash, UploadItem::FILE_MIME_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_file_mime()));
    apr_hash_set(hash, UploadItem::TIME_KEY, APR_HASH_KEY_STRING,
                 create(pool, item->get_time()));

    return create(pool, hash);
}

TemplateVariableCreator::variable *TemplateVariableCreator::create(apr_pool_t *pool, const char *str)
{
    variable *var;

    var = reinterpret_cast<variable *>(apr_palloc(pool, sizeof(variable)));
    var->type = TemplateExecutor::SCALAR;
    var->s_val = reinterpret_cast<scalar *>(apr_palloc(pool, sizeof(scalar)));
    var->s_val->type = TemplateExecutor::STRING;
    var->s_val->s_val = str;

    return var;
}

TemplateVariableCreator::variable *TemplateVariableCreator::create(apr_pool_t *pool, apr_hash_t *hash)
{
    variable *var;

    var = reinterpret_cast<variable *>(apr_palloc(pool, sizeof(variable)));
    var->type = TemplateExecutor::HASH;
    var->h_val = hash;

    return var;
}

TemplateVariableCreator::variable *TemplateVariableCreator::create(apr_pool_t *pool, apr_array_header_t *array)
{
    variable *var;

    var = reinterpret_cast<variable *>(apr_palloc(pool, sizeof(variable)));
    var->type = TemplateExecutor::ARRAY;
    var->a_val = array;

    return var;
}

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
