/******************************************************************************
 * mod_uploader / RFC1867Parser.cpp
 ******************************************************************************
 * Copyright (C) 2004 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.cpp 489 2005-08-06 00:20:02Z svn $
 *****************************************************************************/

#include "ThumbnailWriter.h"

#ifdef MAKE_THUMBNAIL
#include "Auxiliary.h"

#include "apr_file_io.h"
#include "apr_strings.h"

#ifdef WIN32
#undef HAVE_INTTYPES_H
#undef HAVE_STDINT_H
#endif
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include <Magick++.h>
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include <stdexcept>

#ifdef DEBUG
#include <iostream>
#endif

const char ThumbnailWriter::FILE_SUFFIX[]       = "." THUMBNAIL_FILE_TYPE;
const apr_size_t ThumbnailWriter::SIZE_LIMIT    = THUMBNAIL_SIZE_LIMIT;
const apr_size_t ThumbnailWriter::WIDTH_LIMIT   = THUMBNAIL_WIDTH_LIMIT;
const apr_size_t ThumbnailWriter::HEIGHT_LIMIT  = THUMBNAIL_HEIGHT_LIMIT;


/******************************************************************************
 * public ᥽å
 *****************************************************************************/
ThumbnailWriter::ThumbnailWriter(apr_pool_t *pool, const char *file_dir,
                                 const char *thumb_dir)
    : pool_(pool),
      file_dir_(file_dir),
      thumb_dir_(thumb_dir)
{

}

void ThumbnailWriter::write(const char *file_path)
{
     try {
         apr_size_t read_size;
         void *buffer;

         buffer = read(file_path, &read_size);
         Magick::Blob data(buffer, read_size);

         Magick::Image image(data);

         Magick::Geometry size = image.size();

         if ((size.width() == 0) || (size.height() == 0)) { // ȽǴϤɤΤ?
             throw "ͥ벽бƤʤΥեǤ";
         }

         calc_size(size);

         image.scale(size);
         image.write(create_thumb_path(pool_, thumb_dir_, file_path));
     } catch(exception &e) {
        throw e.what();
    }
}

const char *ThumbnailWriter::create_thumb_path(apr_pool_t *pool,
                                               const char *thumb_dir,
                                               const char *file_path)
{
    return apr_pstrcat(pool,
                       thumb_dir, "/", file_path, FILE_SUFFIX, NULL);
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
void *ThumbnailWriter::read(const char *file_path, apr_size_t *size)
{
    UploadItem::header *header;
    apr_file_t *file;
    apr_size_t read_size;
    void *buffer;

    UploadItemReader reader(pool_, file_dir_);
    header = reader.read(file_path, &file);

    if (header->file_size > SIZE_LIMIT) {
        // ݤ㳰ꤲ㤤ޤ
        throw "ե륵礭ޤ";
    }

    buffer = apr_palloc(pool_, header->file_size);
    read_size = header->file_size;
    if ((apr_file_read(file, buffer, &read_size) != APR_SUCCESS) ||
        (read_size != header->file_size)) {
        throw "åץɥեɤ߹ޤǤ";
    }
    apr_file_close(file);

    *size = header->file_size;

    return buffer;
}

void ThumbnailWriter::calc_size(Magick::Geometry &size)
{
    if ((size.width() <= WIDTH_LIMIT) && (size.height() <= HEIGHT_LIMIT)) {
        return;
    }

    if ((size.width()/size.height()) > (WIDTH_LIMIT/HEIGHT_LIMIT)) {
        if (size.width() > WIDTH_LIMIT) {
            size.height(size.height()*WIDTH_LIMIT/size.width());
            size.width(WIDTH_LIMIT);
        }
    } else {
        if (size.height() > HEIGHT_LIMIT) {
            size.width(size.width()*HEIGHT_LIMIT/size.height());
            size.height(HEIGHT_LIMIT);
        }
    }
}
#endif


/******************************************************************************
 * ƥ
 *****************************************************************************/
#ifdef DEBUG_ThumbnailWriter

#include "apr_general.h"
#include "apr_file_io.h"

static const char FILE_DIR[]            = "/tmp";

void usage(const char *prog_name)
{
    cerr << "Usage: " << prog_name << " <FILE> <MAGICKDIR>" << endl;
}

int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        if (argc != 2) {
            throw "ѤΥե뤬ꤵƤޤ";
        }

        ThumbnailWriter writer(pool, dirname_ex(pool, argv[1]), FILE_DIR);
        writer.write(basename_ex(argv[1]));
    } catch(const char *message) {
        cerr << "Error: " << message << endl;
        usage(argv[0]);

        return EXIT_FAILURE;
    }

    apr_terminate();

    return EXIT_SUCCESS;
}
#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
