/******************************************************************************
 * mod_uploader / ApachePostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ApachePostReader.cpp 550 2005-09-01 07:23:16Z svn $
 *****************************************************************************/

#include "ApachePostReader.h"
#include "PostReader.h"
#include "Misc.h"

#define APR_WANT_MEMFUNC
#include "apr_want.h"

// #ifdef DEBUG
#include <iostream>
// #endif


#include "http_protocol.h"

/******************************************************************************
 * public ᥽å
 *****************************************************************************/
ApachePostReader::ApachePostReader(apr_size_t block_size, request_rec *r)
    : PostReader(block_size),
      request_(r),
      brigade_(apr_brigade_create(r->pool, r->connection->bucket_alloc)),
      bucket_(NULL),
      is_eos_(false)
{

}

void ApachePostReader::read(char *buffer, apr_size_t *size)
{
    const char *read_data;

    ap_rprintf(request_, "CALL: read\n");
    cout << "CALL: read" << endl;

    *size = 0;

    if (UNLIKELY(is_eos_)) {
        return;
    }

    if (UNLIKELY(bucket_ == NULL)) {
        get_brigade();
    } else if (UNLIKELY(bucket_ == APR_BRIGADE_SENTINEL(brigade_))) {
        apr_brigade_cleanup(brigade_);
        get_brigade();
    }

    if (APR_BUCKET_IS_EOS(bucket_)) {
        is_eos_ = true;
        return;
    } else if (APR_BUCKET_IS_FLUSH(bucket_)) {
        bucket_ = APR_BUCKET_NEXT(bucket_);
        return read(buffer, size);
    }

    apr_bucket_read(bucket_, &read_data, size, APR_BLOCK_READ);

    bucket_ = APR_BUCKET_NEXT(bucket_);
}


/******************************************************************************
 * private ᥽å
 *****************************************************************************/
void ApachePostReader::get_brigade()
{
    ap_rprintf(request_, "CALL: get_brigade\n");
    cout << "CALL: get_brigade" << endl;

    if (ap_get_brigade(request_->input_filters, brigade_, AP_MODE_READBYTES,
                       APR_BLOCK_READ, get_block_size()) != APR_SUCCESS) {
        throw "ꥯɤ߹ߤν˼Ԥޤ";
    }

    bucket_ = APR_BRIGADE_FIRST(brigade_);
}


/******************************************************************************
 * ƥ
 *****************************************************************************/
#ifdef DEBUG_ApachePostReader
#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"

static const apr_size_t BLOCK_SIZE  = 4096;

extern "C" {
static int test_handler(request_rec *r)
{
    ApachePostReader reader(BLOCK_SIZE, r);

    if (strcmp(r->handler, "my_test")) {
        return DECLINED;
    }

    r->content_type = "text/plain";

    ap_rputs("mod_test.....\n", r);

    if (r->header_only) {
        return OK;
    }

    ap_rputs("begin!\n", r);

//     try {
//         char buffer[BLOCK_SIZE];
//         apr_size_t size;

//         while (true) {
//             reader.read(buffer, &size);

//             ap_rprintf(r, "read: %d\n", size);

//             if (size == 0) {
//                 break;
//             }
//         }
//     } catch(const char *message) {
//         ap_rprintf(r, "Error: %s\n", message);

//         return HTTP_INTERNAL_SERVER_ERROR;
//     }

    ap_rputs("finish!\n", r);

    return OK;
}

static void test_register_hooks(apr_pool_t *p)
{
    ap_hook_handler(test_handler, NULL, NULL, APR_HOOK_MIDDLE);
}

module AP_MODULE_DECLARE_DATA test_module = {
    STANDARD20_MODULE_STUFF,
    NULL, NULL, NULL, NULL, NULL,
    test_register_hooks
};
}

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
