/******************************************************************************
 * mod_uploader / mod_uploader_data.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: mod_uploader.h.in 570 2005-09-02 21:21:36Z svn $
 *****************************************************************************/

#ifndef MOD_UPLOADER_DATA_H

#define APR_NOT_DONE_YET 0

#include "httpd.h"
#include "http_config.h"

#include "apr_time.h"
#include "apr_global_mutex.h"
#include "apr_shm.h"

#undef strtoul

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

extern "C" module AP_MODULE_DECLARE_DATA uploader_module;

const apr_size_t MAX_ADDRESS_LENGTH         = 64;

typedef struct Poster {
    apr_time_t time;
    char address[MAX_ADDRESS_LENGTH];
} poster;

typedef struct ServerConfig {
    char *glock_path;
    apr_global_mutex_t *glock;

    char *poster_list_path;
    apr_shm_t *poster_list_shm;
    poster *poster_list;
} sconfig;

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
