/******************************************************************************
 * mod_uploader / UploadItemCreator.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: UploadItemCreator.h 535 2005-08-30 20:15:17Z svn $
 *****************************************************************************/

#ifndef UPLOADITEMCREATOR_H
#define UPLOADITEMCREATOR_H

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#include "UploadItem.h"
#include "RFC1867ParserImpl.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "httpd.h"
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "apr_pools.h"

#include <cstdlib>

using namespace std;

/**
 * @brief åץɥƥ륯饹
 */
class UploadItemCreator
{
public:
    static UploadItem::header *create_header(apr_pool_t *pool, UploadParser::query_map *qmap,
                                             const char **file_path);
private:
    UploadItemCreator(const UploadItemCreator&);
    UploadItemCreator &operator=(const UploadItemCreator&);

    static void validate_query(apr_pool_t *pool, UploadParser::query_map *qmap);
    static void convert_code(apr_pool_t *pool, string &str, const unsigned char *code_pat);
    static void set_file_data(apr_pool_t *pool, UploadItem::header *data,
                              UploadParser::file_content& file,
                              UploadParser::query_map *qmap);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
