/******************************************************************************
 * mod_uploader / MessageDigest5.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: MessageDigest5.h 682 2005-09-15 06:41:06Z svn $
 *****************************************************************************/

#ifndef MESSAGEDIGEST5_H
#define MESSAGEDIGEST5_H

#include "apr.h"

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief MD5 ׻륯饹
 */
class MessageDigest5
{
public:
    MessageDigest5();
    void update(const apr_byte_t *input, apr_size_t size);
    void finish();
    const char *c_str();

private:
    static const apr_byte_t PADDING[64];

    apr_uint32_t state_[4];
    apr_uint32_t size_[2];
    apr_byte_t buffer_[64];
    apr_size_t remain_length_;
    bool is_finish_;
    apr_byte_t digest_bytes_[16];
    char digest_str_[33];

    apr_uint32_t f(apr_uint32_t x, apr_uint32_t y, apr_uint32_t z);
    apr_uint32_t g(apr_uint32_t x, apr_uint32_t y, apr_uint32_t z);
    apr_uint32_t h(apr_uint32_t x, apr_uint32_t y, apr_uint32_t z);
    apr_uint32_t i(apr_uint32_t x, apr_uint32_t y, apr_uint32_t z);
    apr_uint32_t rotl(apr_uint32_t value, apr_uint32_t shift);
    apr_uint32_t round1(apr_uint32_t a, apr_uint32_t b, apr_uint32_t c,
                        apr_uint32_t d, apr_uint32_t x, apr_uint32_t s,
                        apr_uint32_t t);
    apr_uint32_t round2(apr_uint32_t a, apr_uint32_t b, apr_uint32_t c,
                        apr_uint32_t d, apr_uint32_t x, apr_uint32_t s,
                        apr_uint32_t t);
    apr_uint32_t round3(apr_uint32_t a, apr_uint32_t b, apr_uint32_t c,
                        apr_uint32_t d, apr_uint32_t x, apr_uint32_t s,
                        apr_uint32_t t);
    apr_uint32_t round4(apr_uint32_t a, apr_uint32_t b, apr_uint32_t c,
                        apr_uint32_t d, apr_uint32_t x, apr_uint32_t s,
                        apr_uint32_t t);

    void byte2int(const apr_byte_t *bytes, apr_uint32_t *ints);
    void int2byte(const apr_uint32_t *ints, apr_size_t len, apr_byte_t *bytes);
    void process(const apr_byte_t block[64]);
    void create_digest();
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
