/******************************************************************************
 * mod_uploader / RFC1867Parser.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not bcktuired.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: RFC1867Parser.h 682 2005-09-15 06:41:06Z svn $
 *****************************************************************************/

#ifndef RFC1867PARSER_H
#define RFC1867PARSER_H

#include "ApachePostReader.h"
#include "BinString.h"

#ifdef DEBUG_UPLOAD
#include "apr_file_io.h"
#else
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "httpd.h"
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#endif

#include "apr_pools.h"

#undef strtoul

#include <cstdlib>
#include <map>
#include <string>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef DEBUG_UPLOAD
#define request_rec apr_file_t
#endif

using namespace std;

/**
 * @brief RFC1867 Ϥѡ륯饹
 */
template<class FileWriterClass>
class RFC1867Parser
{
public:
    enum param_type {
        NONE,
        TEXT,
        FILE
    };

    typedef struct FileContent {
        string name;
        string tmp_path;
        string mime;
        string digest;
        apr_size_t size;

        FileContent(const char *name, const char *tmp_path,
                    const char *mime, const char *digest, apr_size_t size)
            : name(name),
              tmp_path(tmp_path),
              mime(mime),
              digest(digest),
              size(size)
        {

        }

        FileContent()
            : name(),
              tmp_path(),
              mime(),
              digest(),
              size(0)
        {

        }
    } file_content;

    typedef struct RFC1867Content {
        param_type type;
        string text;
        file_content file;

        RFC1867Content()
            : type(NONE),
              text(),
              file()
        {

        }
    } rfc1867_content;

    typedef map<string, rfc1867_content> query_map; // multimap ǤϤʤ
    typedef pair<string, rfc1867_content> query_pair;

    RFC1867Parser(const char *file_dir,
                  apr_size_t max_text_size, apr_size_t max_file_size,
                  apr_size_t max_item_num,
                  apr_size_t file_offset=0);
    query_map *parse(apr_pool_t *pool, request_rec *request,
                     const char *content_type, apr_size_t content_size,
                     PostReader::progress *progress);

    static void clean_tmp_file(apr_pool_t *pool, query_map *qmap,
                               bool is_strict=false);
#ifdef DEBUG
    static void dump_map(query_map *qmap);
#endif

private:
    /**
     * ǤϡϢ³إåΥιפ READ_BLOCK_SIZE
     * ⾮ʤꤷƤޤإå礭
     * 硤ɤ߹ߤ˼Ԥޤ
     */
    static const apr_size_t READ_BLOCK_SIZE;

    static const char CR_LF[];
    static const char MULTIPART_FORM_DATA[];
    static const char CONTENT_TYPE[];
    static const char CONTENT_DISP[];
    static const char FORM_DATA[];
    static const char BOUNDARY_PARAM[];
    static const char BOUNDARY_PREFIX[];
    static const char ASSIGN;
    static const char QUOTE;
    static const char DELIMITER;
    static const char NAME_PARAM[];
    static const char FILENAME_PARAM[];

    static const char FILE_NAME_TEMPLATE[];

    static const apr_size_t MKTEMP_RETRY_NUMBER;

    typedef struct Handle {
        apr_pool_t * const pool;
        const char * const boundary;
        request_rec * const request;
        const apr_size_t boundary_len;
        const query_map *qmap;
        ApachePostReader reader;
        BinString buffer;

        Handle(apr_pool_t *pool, request_rec *request, const char *boundary,
               query_map *query_map, PostReader::progress *progress)
            : pool(pool),
              boundary(boundary),
              request(request),
              boundary_len(strlen(boundary)),
              qmap(query_map),
              reader(READ_BLOCK_SIZE, request, progress),
              buffer(READ_BLOCK_SIZE*3) // 3 ʾ夸ʤȤޤ
        {

        }
    } handle;

    const char * const file_dir_;
    const apr_size_t max_text_size_;
    const apr_size_t max_file_size_;
    const apr_size_t max_item_num_;
    const apr_size_t file_offset_;

    RFC1867Parser(const RFC1867Parser&);
    RFC1867Parser &operator=(const RFC1867Parser&);

    bool get_content(handle& h, string& name, rfc1867_content& content);
    const char *get_text_content(handle& h);
    const char *get_file_content(handle& h, const char **file_digest, apr_size_t *file_size);
    apr_size_t store_buffer(handle& h);

    static apr_size_t read(handle& h, char *buffer);
    static const char *get_boundary(apr_pool_t *pool, const char *content_type);
    static const char *parse_header(apr_pool_t *pool,
                                    const char *input_start, const char *pattern);
    static const char *get_param(apr_pool_t *pool,
                                 const char *input_start, const char *input_end,
                                 const char *name, const char **value);
    static const char *skip(apr_pool_t *pool,
                            const char * const input_start, const char * const pattern,
                            bool is_must=true);
    static const char *skip_line(apr_pool_t *pool,
                                 const char * const input_start);
    static apr_file_t *create_tmp_file(apr_pool_t *pool,
                                       const char *dir, char **file_path);
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
