#!/usr/bin/env ruby
###############################################################################
# mod_uploader / manage.cgi
###############################################################################
# Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
#
# All rights reserved.
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any
# damages arising from the use of this software.
#
# Permission is granted to anyone to use this software for any
# purpose, including commercial applications, and to alter it and
# redistribute it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must
#    not claim that you wrote the original software. If you use this
#    software in a product, an acknowledgment in the product
#    documentation would be appreciated but is not required.
#
# 2. Altered source versions must be plainly marked as such, and must
#    not be misrepresented as being the original software.
#
# 3. This notice may not be removed or altered from any source
#    distribution.
#
# $Id: manage.cgi 849 2005-10-14 01:32:09Z svn $
###############################################################################

###############################################################################
# Υեϡפʥåץɥե֥饦ͳǺ뤿
#  CGI ץȤǤ
#
# ץ¦Ǥϥѥɤˤ륢ߤƤʤΤǡ
# HTTP ФεǽѤŬ¤򤷤ѤƲ
#
# o ưĶ
#
#     - Apache Portable Runtime 0.9 ʾ
#
#     - Ruby 1.8 ʾ
#
# o 
#
#     $ cd bin
#     $ make
#     ɬפ˱ơ
#     $ chmod 755 manage.cgi
#
# o 
#
#     ʲˤ UPLOADER_URLFILE_DIRTHUMB_DIR ͤ񤭴Ʋ
#     FILE_DIRTHUMB_DIR ϡХѥǻꤷ̵Ǥ
#
# o Ȥ
#
#     ֥饦 manage.cgi ˥ơեαüˤ
#     ֺץܥ򥯥åȥե뤬ޤǧ
#     ϤǤʤΤǡȤϿŤ˹ԤäƲ
#
# o ƥץ졼
#
#     CGI ץȤϡbin/tmpl ʲΥǥ쥯ȥˤƥץ졼Ȥ
#     ŤɽԤޤCSS ɽޤäƤʤ
#     ϡƥץ졼ȤŬ˽Ʋ
#
# o ջ
#
#      CGI  mod_uploader Ʊ¤ưɬפޤ㤦
#     硤եκԤޤ󡥥ե뤬ǤʤƤ褯ʬ
#     ʤϡեκԤˡ
#
#     $ su
#     $ chmod 666 file
#
#     ơեκԤäˡ
#
#     $ su
#     $ chmod 644 file
#
#     Ƥ(file ϡFileDirectory ǻꤷǥ쥯ȥǤ)
#
###############################################################################

require "cgi"
require "item-manager"

###############################################################################
# 
UPLOADER_URL    = "http://192.168.2.10:8080/up/"	# mod_uploader ֤ URL
FILE_DIR        = "../file"                         # FileDirectory ǻꤷǥ쥯ȥ
THUMB_DIR       = "../thumb"                        # ThumbDirectory ǻꤷǥ쥯ȥ
THUMB_EXT       = "jpg"                             # ͥγĥ

###############################################################################
def get_page(cgi)
  if cgi.query_string != nil then
    page_str = cgi.query_string.split(';')[0]
  end

  if page_str != nil then
    page = page_str.to_i
  end

  if page == nil or page == 0 then
    page = 1
  end

  page
end

def get_file_path(cgi)
  cgi.params.keys.find {|key| /^\d+\.\w+$/ =~ key }
end

###############################################################################
cgi = CGI.new

page        = get_page(cgi)
file_path   = get_file_path(cgi)

print cgi.header
begin
  manager = ItemManager.new(UPLOADER_URL, FILE_DIR, THUMB_DIR, THUMB_EXT)

  if file_path == nil then
    print manager.view_page(page)
  else
    print manager.remove_page(file_path, page)
  end
rescue
  print "<pre>\n"
  print CGI.escapeHTML($!.message), "\n"
  print CGI.escapeHTML($!.backtrace), "\n"
  print "</pre>\n"
end


# local Variables:
# mode: ruby
# buffer-file-coding-system: euc-japan-unix
# End:

